/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.bindings;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.kubejs.util.JSObjectType;
import dev.latvian.mods.kubejs.util.ListJS;
import dev.latvian.mods.kubejs.util.MapJS;
import dev.latvian.mods.kubejs.util.UtilsJS;
import dev.latvian.mods.rhino.mod.wrapper.ColorWrapper;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_2512;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2578;
import net.minecraft.class_2579;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5250;
import net.minecraft.class_7417;
import org.jetbrains.annotations.Nullable;

@Info(value="The hub for all things text components. Format text to your hearts content!")
public class TextWrapper {
    @Info(value="Returns a Component of the input")
    public static class_5250 of(@Nullable Object o) {
        Map map;
        if ((o = UtilsJS.wrap(o, JSObjectType.ANY)) == null) {
            return class_2561.method_43470((String)"null");
        }
        if (o instanceof class_5250) {
            class_5250 component = (class_5250)o;
            return component;
        }
        if (o instanceof class_2561) {
            class_2561 component = (class_2561)o;
            return component.method_27661();
        }
        if (o instanceof CharSequence || o instanceof Number || o instanceof Character) {
            return TextWrapper.ofString(o.toString());
        }
        if (o instanceof Enum) {
            Enum e = (Enum)o;
            return TextWrapper.ofString(e.name());
        }
        if (o instanceof class_2519) {
            class_2519 tag = (class_2519)o;
            String s = tag.method_10714();
            if (s.startsWith("{") && s.endsWith("}")) {
                try {
                    return class_2561.class_2562.method_10877((String)s);
                }
                catch (JsonParseException ex) {
                    return class_2561.method_43470((String)("Error: " + String.valueOf((Object)ex)));
                }
            }
            return TextWrapper.ofString(s);
        }
        if (o instanceof Map && ((map = (Map)o).containsKey("text") || map.containsKey("translate"))) {
            Object a;
            class_5250 text;
            if (map.containsKey("text")) {
                text = TextWrapper.ofString(map.get("text").toString());
            } else {
                Object[] with;
                Object v = map.get("with");
                if (v instanceof Collection) {
                    a = (Collection)v;
                    with = new Object[a.size()];
                    int i = 0;
                    Iterator iterator = a.iterator();
                    while (iterator.hasNext()) {
                        Object e1 = iterator.next();
                        with[i] = e1;
                        if (with[i] instanceof MapJS || with[i] instanceof ListJS) {
                            with[i] = TextWrapper.of(e1);
                        }
                        ++i;
                    }
                } else {
                    with = new Object[]{};
                }
                text = class_2561.method_43469((String)map.get("translate").toString(), (Object[])with);
            }
            if (map.containsKey("color")) {
                text.kjs$color(ColorWrapper.of(map.get("color")));
            }
            text.kjs$bold((Boolean)map.getOrDefault("bold", null));
            text.kjs$italic((Boolean)map.getOrDefault("italic", null));
            text.kjs$underlined((Boolean)map.getOrDefault("underlined", null));
            text.kjs$strikethrough((Boolean)map.getOrDefault("strikethrough", null));
            text.kjs$obfuscated((Boolean)map.getOrDefault("obfuscated", null));
            text.kjs$insertion((String)map.getOrDefault("insertion", null));
            text.kjs$font(map.containsKey("font") ? new class_2960(map.get("font").toString()) : null);
            text.kjs$click(map.containsKey("click") ? TextWrapper.clickEventOf(map.get("click")) : null);
            text.kjs$hover(map.containsKey("hover") ? TextWrapper.of(map.get("hover")) : null);
            a = map.get("extra");
            if (a instanceof Iterable) {
                Iterable itr = (Iterable)a;
                for (Object e : itr) {
                    text.method_10852((class_2561)TextWrapper.of(e));
                }
            }
            return text;
        }
        if (o instanceof Iterable) {
            Iterable list = (Iterable)o;
            class_5250 text = class_2561.method_43473();
            for (Object e1 : list) {
                text.method_10852((class_2561)TextWrapper.of(e1));
            }
            return text;
        }
        return TextWrapper.ofString(o.toString());
    }

    @Info(value="Returns a plain component of the string, or empty if it is an empty string")
    public static class_5250 ofString(String s) {
        return s.isEmpty() ? class_2561.method_43473() : class_2561.method_43470((String)s);
    }

    @Info(value="Checks if the passed in component, and all its children are empty")
    public static boolean isEmpty(class_2561 component) {
        return component.method_10851() == class_7417.field_39004 && component.method_10855().isEmpty();
    }

    @Info(value="Returns a ClickEvent of the input")
    public static class_2558 clickEventOf(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof class_2558) {
            class_2558 ce = (class_2558)o;
            return ce;
        }
        JsonObject json = MapJS.json(o);
        if (json != null) {
            String action = class_3518.method_15265((JsonObject)json, (String)"action");
            String value = class_3518.method_15265((JsonObject)json, (String)"value");
            return new class_2558(Objects.requireNonNull(class_2558.class_2559.method_10848((String)action), "Invalid click event action %s!".formatted(action)), value);
        }
        String s = o.toString();
        String[] split = s.split(":", 2);
        return switch (split[0]) {
            case "command" -> new class_2558(class_2558.class_2559.field_11750, split[1]);
            case "suggest_command" -> new class_2558(class_2558.class_2559.field_11745, split[1]);
            case "copy" -> new class_2558(class_2558.class_2559.field_21462, split[1]);
            case "file" -> new class_2558(class_2558.class_2559.field_11746, split[1]);
            default -> {
                class_2558.class_2559 action = class_2558.class_2559.method_10848((String)split[0]);
                if (action != null) {
                    yield new class_2558(action, split[1]);
                }
                yield new class_2558(class_2558.class_2559.field_11749, s);
            }
        };
    }

    @Info(value="Returns a colorful representation of the input nbt. Useful for displaying NBT to the player")
    public static class_2561 prettyPrintNbt(class_2520 tag) {
        return class_2512.method_32270((class_2520)tag);
    }

    @Info(value="Joins all components in the list with the separator component")
    public static class_5250 join(class_5250 separator, Iterable<? extends class_2561> texts) {
        class_5250 joined = class_2561.method_43473();
        boolean first = true;
        for (class_2561 class_25612 : texts) {
            if (first) {
                first = false;
            } else if (!TextWrapper.isEmpty((class_2561)separator)) {
                joined.method_10852((class_2561)separator);
            }
            joined.method_10852(class_25612);
        }
        return joined;
    }

    @Info(value="Returns an empty component")
    public static class_5250 empty() {
        return class_2561.method_43473();
    }

    @Info(value="Joins all components")
    public static class_5250 join(class_2561 ... texts) {
        return TextWrapper.join(class_2561.method_43473(), Arrays.asList(texts));
    }

    @Info(value="Returns a plain component of the passed in string, even if empty")
    public static class_5250 string(String text) {
        return class_2561.method_43470((String)text);
    }

    @Info(value="Returns a plain component of the input")
    public static class_5250 literal(String text) {
        return class_2561.method_43470((String)text);
    }

    @Info(value="Returns a translatable component of the input key")
    public static class_5250 translate(String key) {
        return class_2561.method_43471((String)key);
    }

    @Info(value="Returns a translatable component of the input key, with args of the objects")
    public static class_5250 translate(String key, Object ... objects) {
        return class_2561.method_43469((String)key, (Object[])objects);
    }

    @Info(value="Returns a translatable component of the input key")
    public static class_5250 translatable(String key) {
        return class_2561.method_43471((String)key);
    }

    @Info(value="Returns a translatable component of the input key, with args of the objects")
    public static class_5250 translatable(String key, Object ... objects) {
        return class_2561.method_43469((String)key, (Object[])objects);
    }

    @Info(value="Returns a keybinding component of the input keybinding descriptor")
    public static class_5250 keybind(String keybind) {
        return class_2561.method_43472((String)keybind);
    }

    @Info(value="Returns a score component of the input objective, for the provided selector")
    public static class_5250 score(String selector, String objective) {
        return class_5250.method_43477((class_7417)new class_2578(selector, objective));
    }

    @Info(value="Returns a component displaying all entities matching the input selector")
    public static class_5250 selector(String selector) {
        return class_5250.method_43477((class_7417)new class_2579(selector, Optional.empty()));
    }

    @Info(value="Returns a component displaying all entities matching the input selector, with a custom separator")
    public static class_5250 selector(String selector, class_2561 separator) {
        return class_5250.method_43477((class_7417)new class_2579(selector, Optional.of(separator)));
    }

    @Info(value="Returns a component of the input, colored black")
    public static class_5250 black(Object text) {
        return TextWrapper.of(text).kjs$black();
    }

    @Info(value="Returns a component of the input, colored dark blue")
    public static class_5250 darkBlue(Object text) {
        return TextWrapper.of(text).kjs$darkBlue();
    }

    @Info(value="Returns a component of the input, colored dark green")
    public static class_5250 darkGreen(Object text) {
        return TextWrapper.of(text).kjs$darkGreen();
    }

    @Info(value="Returns a component of the input, colored dark aqua")
    public static class_5250 darkAqua(Object text) {
        return TextWrapper.of(text).kjs$darkAqua();
    }

    @Info(value="Returns a component of the input, colored dark red")
    public static class_5250 darkRed(Object text) {
        return TextWrapper.of(text).kjs$darkRed();
    }

    @Info(value="Returns a component of the input, colored dark purple")
    public static class_5250 darkPurple(Object text) {
        return TextWrapper.of(text).kjs$darkPurple();
    }

    @Info(value="Returns a component of the input, colored gold")
    public static class_5250 gold(Object text) {
        return TextWrapper.of(text).kjs$gold();
    }

    @Info(value="Returns a component of the input, colored gray")
    public static class_5250 gray(Object text) {
        return TextWrapper.of(text).kjs$gray();
    }

    @Info(value="Returns a component of the input, colored dark gray")
    public static class_5250 darkGray(Object text) {
        return TextWrapper.of(text).kjs$darkGray();
    }

    @Info(value="Returns a component of the input, colored blue")
    public static class_5250 blue(Object text) {
        return TextWrapper.of(text).kjs$blue();
    }

    @Info(value="Returns a component of the input, colored green")
    public static class_5250 green(Object text) {
        return TextWrapper.of(text).kjs$green();
    }

    @Info(value="Returns a component of the input, colored aqua")
    public static class_5250 aqua(Object text) {
        return TextWrapper.of(text).kjs$aqua();
    }

    @Info(value="Returns a component of the input, colored red")
    public static class_5250 red(Object text) {
        return TextWrapper.of(text).kjs$red();
    }

    @Info(value="Returns a component of the input, colored light purple")
    public static class_5250 lightPurple(Object text) {
        return TextWrapper.of(text).kjs$lightPurple();
    }

    @Info(value="Returns a component of the input, colored yellow")
    public static class_5250 yellow(Object text) {
        return TextWrapper.of(text).kjs$yellow();
    }

    @Info(value="Returns a component of the input, colored white")
    public static class_5250 white(Object text) {
        return TextWrapper.of(text).kjs$white();
    }
}

