/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.client;

import dev.architectury.hooks.PackRepositoryHooks;
import dev.architectury.platform.Platform;
import dev.architectury.registry.menu.MenuRegistry;
import dev.latvian.mods.kubejs.CommonProperties;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.KubeJSCommon;
import dev.latvian.mods.kubejs.KubeJSPaths;
import dev.latvian.mods.kubejs.KubeJSPlugin;
import dev.latvian.mods.kubejs.bindings.event.ClientEvents;
import dev.latvian.mods.kubejs.bindings.event.ItemEvents;
import dev.latvian.mods.kubejs.bindings.event.NetworkEvents;
import dev.latvian.mods.kubejs.client.AtlasSpriteRegistryEventJS;
import dev.latvian.mods.kubejs.client.ClientInitEventJS;
import dev.latvian.mods.kubejs.client.ClientProperties;
import dev.latvian.mods.kubejs.client.KubeJSClientEventHandler;
import dev.latvian.mods.kubejs.client.KubeJSErrorScreen;
import dev.latvian.mods.kubejs.client.KubeJSResourcePackFinder;
import dev.latvian.mods.kubejs.client.painter.Painter;
import dev.latvian.mods.kubejs.fluid.FluidBuilder;
import dev.latvian.mods.kubejs.gui.KubeJSMenu;
import dev.latvian.mods.kubejs.gui.KubeJSScreen;
import dev.latvian.mods.kubejs.item.ItemModelPropertiesEventJS;
import dev.latvian.mods.kubejs.net.NetworkEventJS;
import dev.latvian.mods.kubejs.registry.BuilderBase;
import dev.latvian.mods.kubejs.registry.RegistryInfo;
import dev.latvian.mods.kubejs.script.ConsoleLine;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.script.ScriptTypeHolder;
import dev.latvian.mods.kubejs.script.data.ExportablePackResources;
import dev.latvian.mods.kubejs.script.data.GeneratedData;
import dev.latvian.mods.kubejs.util.KubeJSPlugins;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.class_1059;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3262;
import net.minecraft.class_3283;
import net.minecraft.class_3285;
import net.minecraft.class_3302;
import net.minecraft.class_3611;
import net.minecraft.class_3694;
import net.minecraft.class_3695;
import net.minecraft.class_437;
import net.minecraft.class_7225;
import net.minecraft.class_7699;
import net.minecraft.class_7706;
import org.jetbrains.annotations.Nullable;

public class KubeJSClient
extends KubeJSCommon {
    @Override
    public void init() {
        if (class_310.method_1551() == null) {
            return;
        }
        KubeJSClient.reloadClientScripts();
        new KubeJSClientEventHandler().init();
        class_3283 list = class_310.method_1551().method_1520();
        PackRepositoryHooks.addSource((class_3283)list, (class_3285)new KubeJSResourcePackFinder());
        KubeJSPlugins.forEachPlugin(KubeJSPlugin::clientInit);
    }

    @Override
    public void reloadClientInternal() {
        KubeJSClient.reloadClientScripts();
    }

    public static void reloadClientScripts() {
        KubeJSClientEventHandler.staticItemTooltips = null;
        class_310 mc = class_310.method_1551();
        if (mc != null) {
            KubeJS.getClientScriptManager().reload(mc.method_1478());
        }
    }

    public static void copyDefaultOptionsFile(File optionsFile) {
        Path defOptions;
        if (!optionsFile.exists() && Files.exists(defOptions = KubeJSPaths.CONFIG.resolve("defaultoptions.txt"), new LinkOption[0])) {
            try {
                KubeJS.LOGGER.info("Loaded default options from kubejs/config/defaultoptions.txt");
                Files.copy(defOptions, optionsFile.toPath(), new CopyOption[0]);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void clientSetup() {
        if (Platform.isDevelopmentEnvironment()) {
            KubeJS.LOGGER.info("CLIENT SETUP");
        }
        ClientEvents.INIT.post(ScriptType.STARTUP, new ClientInitEventJS());
        ItemEvents.MODEL_PROPERTIES.post(ScriptType.STARTUP, new ItemModelPropertiesEventJS());
        ClientEvents.ATLAS_SPRITE_REGISTRY.listenJava(ScriptType.CLIENT, class_1059.field_5275, event -> {
            AtlasSpriteRegistryEventJS e = (AtlasSpriteRegistryEventJS)event;
            for (BuilderBase<class_3611> builderBase : RegistryInfo.FLUID) {
                if (!(builderBase instanceof FluidBuilder)) continue;
                FluidBuilder b = (FluidBuilder)builderBase;
                e.register(b.stillTexture);
                e.register(b.flowingTexture);
            }
            return null;
        });
        if (!CommonProperties.get().serverOnly) {
            MenuRegistry.registerScreenFactory(KubeJSMenu.KUBEJS_MENU.get(), KubeJSScreen::new);
        }
    }

    @Override
    public void handleDataFromServerPacket(String channel, @Nullable class_2487 data) {
        if (NetworkEvents.DATA_RECEIVED.hasListeners(channel)) {
            NetworkEvents.DATA_RECEIVED.post((ScriptTypeHolder)ScriptType.CLIENT, (Object)channel, new NetworkEventJS((class_1657)class_310.method_1551().field_1724, channel, data));
        }
    }

    @Override
    @Nullable
    public class_1657 getClientPlayer() {
        return class_310.method_1551().field_1724;
    }

    @Override
    public void paint(class_2487 tag) {
        Painter.INSTANCE.paint(tag);
    }

    private void reload(class_3302 listener) {
        long start = System.currentTimeMillis();
        class_310 mc = class_310.method_1551();
        mc.method_1478().method_14486(GeneratedData.INTERNAL_RELOAD.id());
        listener.method_25931(CompletableFuture::completedFuture, mc.method_1478(), (class_3695)class_3694.field_16280, (class_3695)class_3694.field_16280, (Executor)class_156.method_18349(), (Executor)mc).thenAccept(unused -> mc.field_1724.method_43496((class_2561)class_2561.method_43470((String)"Done! You still may have to reload all assets with F3 + T")));
    }

    @Override
    public void reloadTextures() {
        this.reload((class_3302)class_310.method_1551().method_1531());
    }

    @Override
    public void reloadLang() {
        KubeJSClient.reloadClientScripts();
        this.reload((class_3302)class_310.method_1551().method_1526());
    }

    @Override
    public void generateTypings(class_2168 source) {
        source.method_9226(() -> class_2561.method_43470((String)"WIP!"), false);
    }

    @Override
    public void reloadConfig() {
        super.reloadConfig();
        ClientProperties.reload();
    }

    @Override
    public void reloadStartupScripts(boolean dedicated) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 != null) {
            class_7706.field_42466 = null;
            class_7706.method_47330((class_7699)mc.field_1724.field_3944.method_45735(), (mc.field_1724.method_7338() && (Boolean)mc.field_1690.method_47395().method_41753() != false ? 1 : 0) != 0, (class_7225.class_7874)mc.field_1687.method_30349());
        }
    }

    @Override
    public void export(List<ExportablePackResources> packs) {
        for (class_3262 pack : class_310.method_1551().method_1478().method_29213().toList()) {
            ExportablePackResources e;
            if (!(pack instanceof ExportablePackResources) || packs.contains(e = (ExportablePackResources)pack)) continue;
            packs.add(e);
        }
    }

    @Override
    public void openErrors(ScriptType type) {
        class_310.method_1551().execute(() -> class_310.method_1551().method_1507((class_437)new KubeJSErrorScreen(class_310.method_1551().field_1755, type.console)));
    }

    @Override
    public void openErrors(ScriptType type, List<ConsoleLine> errors, List<ConsoleLine> warnings) {
        class_310.method_1551().execute(() -> class_310.method_1551().method_1507((class_437)new KubeJSErrorScreen(class_310.method_1551().field_1755, type, null, errors, warnings)));
    }
}

