/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.client;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.event.events.client.ClientPlayerEvent;
import dev.architectury.event.events.client.ClientTooltipEvent;
import dev.architectury.hooks.client.screen.ScreenAccess;
import dev.architectury.hooks.fluid.FluidBucketHooks;
import dev.latvian.mods.kubejs.CommonProperties;
import dev.latvian.mods.kubejs.bindings.event.ClientEvents;
import dev.latvian.mods.kubejs.bindings.event.ItemEvents;
import dev.latvian.mods.kubejs.client.ClientEventJS;
import dev.latvian.mods.kubejs.client.ClientProperties;
import dev.latvian.mods.kubejs.client.DebugInfoEventJS;
import dev.latvian.mods.kubejs.client.KubeJSErrorScreen;
import dev.latvian.mods.kubejs.client.TagInstance;
import dev.latvian.mods.kubejs.client.painter.Painter;
import dev.latvian.mods.kubejs.core.ImageButtonKJS;
import dev.latvian.mods.kubejs.item.ItemTooltipEventJS;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import dev.latvian.mods.kubejs.util.Tags;
import java.lang.invoke.LambdaMetafactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_1747;
import net.minecraft.class_1755;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1826;
import net.minecraft.class_1836;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_518;
import net.minecraft.class_6862;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

public class KubeJSClientEventHandler {
    private static final class_2960 RECIPE_BUTTON_TEXTURE = new class_2960("textures/gui/recipe_button.png");
    public static Map<class_1792, List<ItemTooltipEventJS.StaticTooltipHandler>> staticItemTooltips = null;
    private final Map<class_2960, TagInstance> tempTagNames = new LinkedHashMap<class_2960, TagInstance>();

    public void init() {
        ClientGuiEvent.DEBUG_TEXT_LEFT.register(this::debugInfoLeft);
        ClientGuiEvent.DEBUG_TEXT_RIGHT.register(this::debugInfoRight);
        ClientTooltipEvent.ITEM.register(this::itemTooltip);
        ClientPlayerEvent.CLIENT_PLAYER_JOIN.register(this::loggedIn);
        ClientPlayerEvent.CLIENT_PLAYER_QUIT.register(this::loggedOut);
        ClientPlayerEvent.CLIENT_PLAYER_RESPAWN.register(this::respawn);
        ClientGuiEvent.RENDER_HUD.register(Painter.INSTANCE::inGameScreenDraw);
        ClientGuiEvent.RENDER_POST.register(Painter.INSTANCE::guiScreenDraw);
        ClientGuiEvent.INIT_PRE.register(this::guiPreInit);
        ClientGuiEvent.INIT_POST.register(this::guiPostInit);
    }

    private void debugInfoLeft(List<String> lines) {
        if (class_310.method_1551().field_1724 != null && ClientEvents.DEBUG_LEFT.hasListeners()) {
            ClientEvents.DEBUG_LEFT.post(ScriptType.CLIENT, new DebugInfoEventJS(lines));
        }
    }

    private void debugInfoRight(List<String> lines) {
        if (class_310.method_1551().field_1724 != null && ClientEvents.DEBUG_RIGHT.hasListeners()) {
            ClientEvents.DEBUG_RIGHT.post(ScriptType.CLIENT, new DebugInfoEventJS(lines));
        }
    }

    private void itemTooltip(class_1799 stack, List<class_2561> lines, class_1836 flag) {
        if (stack.method_7960()) {
            return;
        }
        boolean advanced = flag.method_8035();
        if (advanced && ClientProperties.get().getShowTagNames() && class_437.method_25442()) {
            class_1755 bucket;
            class_1792 fluid;
            Object item;
            Consumer<class_6862> addToTempTags = tag -> this.tempTagNames.computeIfAbsent((class_2960)tag.comp_327(), (Function<class_2960, TagInstance>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, <init>(net.minecraft.class_2960 ), (Lnet/minecraft/class_2960;)Ldev/latvian/mods/kubejs/client/TagInstance;)()).registries.add(tag.comp_326());
            Tags.byItemStack(stack).forEach((Consumer<class_6862<class_1792>>)addToTempTags);
            class_1792 class_17922 = stack.method_7909();
            if (class_17922 instanceof class_1747) {
                item = (class_1747)class_17922;
                Tags.byBlock(item.method_7711()).forEach((Consumer<class_6862<class_2248>>)addToTempTags);
            }
            if ((class_17922 = stack.method_7909()) instanceof class_1755 && (fluid = FluidBucketHooks.getFluid((class_1755)(bucket = (class_1755)class_17922))) != class_3612.field_15906) {
                Tags.byFluid((class_3611)fluid).forEach((Consumer<class_6862<class_3611>>)addToTempTags);
            }
            if ((fluid = stack.method_7909()) instanceof class_1826) {
                item = (class_1826)fluid;
                Tags.byEntityType(item.method_8015(stack.method_7969())).forEach(addToTempTags);
            }
            for (TagInstance instance : this.tempTagNames.values()) {
                lines.add(instance.toText());
            }
            this.tempTagNames.clear();
        }
        if (staticItemTooltips == null) {
            staticItemTooltips = new HashMap<class_1792, List<ItemTooltipEventJS.StaticTooltipHandler>>();
            ItemEvents.TOOLTIP.post(ScriptType.CLIENT, new ItemTooltipEventJS(staticItemTooltips));
        }
        try {
            for (ItemTooltipEventJS.StaticTooltipHandler handler : staticItemTooltips.getOrDefault(class_1802.field_8162, List.of())) {
                handler.tooltip(stack, advanced, lines);
            }
        }
        catch (Exception ex) {
            ConsoleJS.CLIENT.error("Error while gathering tooltip for " + String.valueOf(stack), ex);
        }
        try {
            for (ItemTooltipEventJS.StaticTooltipHandler handler : staticItemTooltips.getOrDefault(stack.method_7909(), List.of())) {
                handler.tooltip(stack, advanced, lines);
            }
        }
        catch (Exception ex) {
            ConsoleJS.CLIENT.error("Error while gathering tooltip for " + String.valueOf(stack), ex);
        }
    }

    private void loggedIn(class_746 player) {
        ClientEvents.LOGGED_IN.post(ScriptType.CLIENT, new ClientEventJS());
    }

    private void loggedOut(class_746 player) {
        ClientEvents.LOGGED_OUT.post(ScriptType.CLIENT, new ClientEventJS());
        Painter.INSTANCE.clear();
    }

    private void respawn(class_746 oldPlayer, class_746 newPlayer) {
    }

    @Nullable
    public static class_437 setScreen(class_437 screen) {
        if (screen instanceof class_442 && !ConsoleJS.STARTUP.errors.isEmpty() && CommonProperties.get().startupErrorGUI) {
            return new KubeJSErrorScreen(screen, ConsoleJS.STARTUP);
        }
        return screen;
    }

    private EventResult guiPreInit(class_437 screen, ScreenAccess screenAccess) {
        return EventResult.pass();
    }

    private void guiPostInit(class_437 screen, ScreenAccess access) {
        if (ClientProperties.get().getDisableRecipeBook() && screen instanceof class_518) {
            Iterator iterator = screen.method_25396().iterator();
            while (iterator.hasNext()) {
                ImageButtonKJS buttonKJS;
                class_364 listener = (class_364)iterator.next();
                if (!(listener instanceof class_339) || !(listener instanceof ImageButtonKJS) || !RECIPE_BUTTON_TEXTURE.equals((Object)(buttonKJS = (ImageButtonKJS)listener).kjs$getButtonTexture())) continue;
                access.getRenderables().remove(listener);
                access.getNarratables().remove(listener);
                iterator.remove();
                return;
            }
        }
    }
}

