/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.level.gen;

import com.google.common.collect.ImmutableSet;
import dev.architectury.hooks.level.biome.BiomeProperties;
import dev.architectury.registry.level.biome.BiomeModifications;
import dev.latvian.mods.kubejs.event.StartupEventJS;
import dev.latvian.mods.kubejs.level.gen.filter.biome.BiomeFilter;
import dev.latvian.mods.kubejs.level.gen.properties.RemoveOresProperties;
import dev.latvian.mods.kubejs.level.gen.properties.RemoveSpawnsProperties;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_1311;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_3037;
import net.minecraft.class_3124;
import net.minecraft.class_3154;
import net.minecraft.class_5321;
import net.minecraft.class_5483;
import net.minecraft.class_6796;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;

public class RemoveWorldgenEventJS
extends StartupEventJS {
    protected static boolean checkTree(class_2975<?, ?> configuredFeature, Predicate<class_3037> predicate) {
        return predicate.test(configuredFeature.comp_333()) || configuredFeature.comp_333().method_30649().anyMatch(cf -> RemoveWorldgenEventJS.checkTree(cf, predicate));
    }

    private void removeFeature(BiomeFilter filter, class_2893.class_2895 decoration, Predicate<class_3037> predicate) {
        BiomeModifications.replaceProperties((Predicate)filter, (ctx, properties) -> {
            ArrayList removedFeatures = new ArrayList();
            for (class_6880 feature : properties.getGenerationProperties().getFeatures(decoration)) {
                if (!RemoveWorldgenEventJS.checkTree((class_2975)((class_6796)feature.comp_349()).comp_334().comp_349(), predicate)) continue;
                feature.method_40230().ifPresentOrElse(key -> {
                    ConsoleJS.STARTUP.debug("Removing feature %s from generation step %s in biome %s".formatted(key, decoration.name().toLowerCase(), ctx.getKey()));
                    removedFeatures.add(feature);
                }, () -> ConsoleJS.STARTUP.warn("Feature %s was not removed since it was not found in the registry!".formatted(feature.comp_349())));
            }
            for (class_6880 feature : removedFeatures) {
                properties.getGenerationProperties().removeFeature(decoration, (class_5321)feature.method_40230().get());
            }
        });
    }

    private void removeSpawn(BiomeFilter filter, BiPredicate<class_1311, class_5483.class_1964> predicate) {
        BiomeModifications.replaceProperties((Predicate)filter, (ctx, properties) -> properties.getSpawnProperties().removeSpawns(predicate));
    }

    public void printFeatures() {
        this.printFeatures(null);
    }

    public void printFiltered() {
        this.printFiltered(null);
    }

    public void printFeatures(@Nullable class_2893.class_2895 type) {
        this.printFeatures(type, BiomeFilter.ALWAYS_TRUE);
    }

    public void printFiltered(@Nullable class_2893.class_2895 type) {
        this.printFiltered(type, BiomeFilter.ALWAYS_TRUE);
    }

    public void printFeatures(@Nullable class_2893.class_2895 type, BiomeFilter filter) {
        this.printFeaturesForType(type, filter, false);
    }

    public void printFiltered(@Nullable class_2893.class_2895 type, BiomeFilter filter) {
        this.printFeaturesForType(type, filter, true);
    }

    public void printFeaturesForType(final @Nullable class_2893.class_2895 type, BiomeFilter filter, boolean afterRemoval) {
        if (type == null) {
            for (class_2893.class_2895 step : class_2893.class_2895.values()) {
                this.printFeaturesForType(step, filter, afterRemoval);
            }
        } else {
            BiConsumer<BiomeModifications.BiomeContext, BiomeProperties.Mutable> printer = new BiConsumer<BiomeModifications.BiomeContext, BiomeProperties.Mutable>(){
                boolean called = false;

                @Override
                public void accept(BiomeModifications.BiomeContext ctx, BiomeProperties.Mutable properties) {
                    if (this.called) {
                        return;
                    }
                    this.called = true;
                    Optional biome = ctx.getKey();
                    Iterable features = properties.getGenerationProperties().getFeatures(type);
                    ConsoleJS.STARTUP.info("Features with type '%s' in biome '%s':".formatted(type.name().toLowerCase(), biome));
                    MutableInt unknown = new MutableInt(0);
                    for (class_6880 feature : features) {
                        feature.method_40230().ifPresentOrElse(key -> ConsoleJS.STARTUP.info("- " + String.valueOf(key)), () -> ((MutableInt)unknown).increment());
                    }
                    if (unknown.intValue() > 0) {
                        ConsoleJS.STARTUP.info("- " + String.valueOf(unknown) + " features with unknown id");
                    }
                }
            };
            if (afterRemoval) {
                BiomeModifications.postProcessProperties((Predicate)filter, (BiConsumer)printer);
            } else {
                BiomeModifications.removeProperties((Predicate)filter, (BiConsumer)printer);
            }
        }
    }

    public void removeFeatureById(BiomeFilter filter, class_2893.class_2895 decoration, class_2960[] ids) {
        BiomeModifications.replaceProperties((Predicate)filter, (ctx, properties) -> Stream.of(ids).map(id -> class_5321.method_29179((class_5321)class_7924.field_41245, (class_2960)id)).forEach(id -> properties.getGenerationProperties().removeFeature(decoration, id)));
    }

    public void removeFeatureById(class_2893.class_2895 type, class_2960[] ids) {
        this.removeFeatureById(BiomeFilter.ALWAYS_TRUE, type, ids);
    }

    public void removeAllFeatures(BiomeFilter filter, class_2893.class_2895 type) {
        this.removeFeature(filter, type, configuredFeature -> true);
    }

    public void removeAllFeatures(BiomeFilter filter) {
        for (class_2893.class_2895 decoration : class_2893.class_2895.values()) {
            this.removeAllFeatures(filter, decoration);
        }
    }

    public void removeAllFeatures() {
        this.removeAllFeatures(BiomeFilter.ALWAYS_TRUE);
    }

    public void removeOres(Consumer<RemoveOresProperties> p) {
        RemoveOresProperties properties = new RemoveOresProperties();
        p.accept(properties);
        this.removeFeature(properties.biomes, properties.worldgenLayer, fc -> {
            if (fc instanceof class_3124) {
                class_3124 ore = (class_3124)fc;
                return properties.blocks.check(ore.field_29063);
            }
            if (fc instanceof class_3154) {
                class_3154 rb = (class_3154)fc;
                return properties.blocks.check(rb.field_13765);
            }
            return false;
        });
    }

    public void printSpawns(@Nullable class_1311 category) {
        BiomeModifications.addProperties((ctx, properties) -> {
            Optional biome = ctx.getKey();
            Map spawns = properties.getSpawnProperties().getSpawners();
            ImmutableSet cats = category == null ? spawns.keySet() : ImmutableSet.of((Object)category);
            for (class_1311 cat : cats) {
                ConsoleJS.STARTUP.info("Mob spawns with type '%s' in biome '%s':".formatted(cat.method_6133(), biome));
                for (class_5483.class_1964 data : (List)spawns.get(cat)) {
                    ConsoleJS.STARTUP.info("- " + data.toString());
                }
            }
        });
    }

    public void printSpawns() {
        this.printSpawns(null);
    }

    public void removeSpawns(Consumer<RemoveSpawnsProperties> p) {
        RemoveSpawnsProperties properties = new RemoveSpawnsProperties();
        p.accept(properties);
        this.removeSpawn(properties.biomes, properties.mobs);
    }

    public void removeAllSpawns() {
        this.removeSpawn(BiomeFilter.ALWAYS_TRUE, (mobCategory, spawnerData) -> true);
    }
}

