/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.registry;

import com.mojang.serialization.Codec;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrarManager;
import dev.latvian.mods.kubejs.CommonProperties;
import dev.latvian.mods.kubejs.DevProperties;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.bindings.event.StartupEvents;
import dev.latvian.mods.kubejs.registry.BuilderBase;
import dev.latvian.mods.kubejs.registry.BuilderFactory;
import dev.latvian.mods.kubejs.registry.BuilderType;
import dev.latvian.mods.kubejs.registry.RegistryCallback;
import dev.latvian.mods.kubejs.registry.RegistryEventJS;
import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import dev.latvian.mods.kubejs.util.UtilsJS;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.util.wrap.TypeWrapperFactory;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1291;
import net.minecraft.class_1299;
import net.minecraft.class_1320;
import net.minecraft.class_1535;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1842;
import net.minecraft.class_1865;
import net.minecraft.class_1887;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2314;
import net.minecraft.class_2378;
import net.minecraft.class_2396;
import net.minecraft.class_2556;
import net.minecraft.class_2582;
import net.minecraft.class_2591;
import net.minecraft.class_2806;
import net.minecraft.class_2874;
import net.minecraft.class_2922;
import net.minecraft.class_2939;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_3031;
import net.minecraft.class_3195;
import net.minecraft.class_3414;
import net.minecraft.class_3448;
import net.minecraft.class_3611;
import net.minecraft.class_3773;
import net.minecraft.class_3785;
import net.minecraft.class_3816;
import net.minecraft.class_3827;
import net.minecraft.class_3828;
import net.minecraft.class_3852;
import net.minecraft.class_3854;
import net.minecraft.class_3917;
import net.minecraft.class_3956;
import net.minecraft.class_4140;
import net.minecraft.class_4149;
import net.minecraft.class_4158;
import net.minecraft.class_4168;
import net.minecraft.class_4170;
import net.minecraft.class_4648;
import net.minecraft.class_4652;
import net.minecraft.class_4663;
import net.minecraft.class_4996;
import net.minecraft.class_5142;
import net.minecraft.class_5202;
import net.minecraft.class_5216;
import net.minecraft.class_5284;
import net.minecraft.class_5321;
import net.minecraft.class_5338;
import net.minecraft.class_5339;
import net.minecraft.class_5342;
import net.minecraft.class_5363;
import net.minecraft.class_5497;
import net.minecraft.class_5650;
import net.minecraft.class_5657;
import net.minecraft.class_5669;
import net.minecraft.class_5712;
import net.minecraft.class_5717;
import net.minecraft.class_5864;
import net.minecraft.class_6018;
import net.minecraft.class_6123;
import net.minecraft.class_6647;
import net.minecraft.class_6796;
import net.minecraft.class_6798;
import net.minecraft.class_6875;
import net.minecraft.class_6910;
import net.minecraft.class_7059;
import net.minecraft.class_7106;
import net.minecraft.class_7142;
import net.minecraft.class_7145;
import net.minecraft.class_7151;
import net.minecraft.class_7375;
import net.minecraft.class_7388;
import net.minecraft.class_7444;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8054;
import net.minecraft.class_8056;
import net.minecraft.class_8110;
import net.minecraft.class_8197;
import net.minecraft.class_8249;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RegistryInfo<T>
implements Iterable<BuilderBase<? extends T>>,
TypeWrapperFactory<T> {
    public static final Map<class_5321<? extends class_2378<?>>, RegistryInfo<?>> MAP = Collections.synchronizedMap(new LinkedHashMap());
    public static final List<BuilderBase<?>> ALL_BUILDERS = new LinkedList();
    @Info(value="Platform-agnostic wrapper of minecraft registries, can be used to register content or get objects from the registry")
    private static final RegistrarManager REGISTRIES = RegistrarManager.get((String)"kubejs");
    public static final RegistryInfo<class_3414> SOUND_EVENT = RegistryInfo.of(class_7924.field_41225, class_3414.class);
    public static final RegistryInfo<class_3611> FLUID = RegistryInfo.of(class_7924.field_41270, class_3611.class);
    public static final RegistryInfo<class_1291> MOB_EFFECT = RegistryInfo.of(class_7924.field_41208, class_1291.class).languageKeyPrefix("effect");
    public static final RegistryInfo<class_2248> BLOCK = RegistryInfo.of(class_7924.field_41254, class_2248.class);
    public static final RegistryInfo<class_1887> ENCHANTMENT = RegistryInfo.of(class_7924.field_41265, class_1887.class);
    public static final RegistryInfo<class_1299> ENTITY_TYPE = RegistryInfo.of(class_7924.field_41266, class_1299.class);
    public static final RegistryInfo<class_1792> ITEM = RegistryInfo.of(class_7924.field_41197, class_1792.class).noAutoWrap();
    public static final RegistryInfo<class_1842> POTION = RegistryInfo.of(class_7924.field_41215, class_1842.class);
    public static final RegistryInfo<class_2396> PARTICLE_TYPE = RegistryInfo.of(class_7924.field_41210, class_2396.class);
    public static final RegistryInfo<class_2591> BLOCK_ENTITY_TYPE = RegistryInfo.of(class_7924.field_41255, class_2591.class);
    public static final RegistryInfo<class_1535> PAINTING_VARIANT = RegistryInfo.of(class_7924.field_41209, class_1535.class);
    public static final RegistryInfo<class_2960> CUSTOM_STAT = RegistryInfo.of(class_7924.field_41263, class_2960.class);
    public static final RegistryInfo<class_2806> CHUNK_STATUS = RegistryInfo.of(class_7924.field_41261, class_2806.class);
    public static final RegistryInfo<class_3827> RULE_TEST = RegistryInfo.of(class_7924.field_41219, class_3827.class);
    public static final RegistryInfo<class_4996> POS_RULE_TEST = RegistryInfo.of(class_7924.field_41214, class_4996.class);
    public static final RegistryInfo<class_3917> MENU = RegistryInfo.of(class_7924.field_41207, class_3917.class);
    public static final RegistryInfo<class_3956> RECIPE_TYPE = RegistryInfo.of(class_7924.field_41217, class_3956.class);
    public static final RegistryInfo<class_1865> RECIPE_SERIALIZER = RegistryInfo.of(class_7924.field_41216, class_1865.class);
    public static final RegistryInfo<class_1320> ATTRIBUTE = RegistryInfo.of(class_7924.field_41251, class_1320.class);
    public static final RegistryInfo<class_5712> GAME_EVENT = RegistryInfo.of(class_7924.field_41273, class_5712.class);
    public static final RegistryInfo<class_5717> POSITION_SOURCE_TYPE = RegistryInfo.of(class_7924.field_41213, class_5717.class);
    public static final RegistryInfo<class_3448> STAT_TYPE = RegistryInfo.of(class_7924.field_41226, class_3448.class);
    public static final RegistryInfo<class_3854> VILLAGER_TYPE = RegistryInfo.of(class_7924.field_41235, class_3854.class);
    public static final RegistryInfo<class_3852> VILLAGER_PROFESSION = RegistryInfo.of(class_7924.field_41234, class_3852.class);
    public static final RegistryInfo<class_4158> POINT_OF_INTEREST_TYPE = RegistryInfo.of(class_7924.field_41212, class_4158.class);
    public static final RegistryInfo<class_4140> MEMORY_MODULE_TYPE = RegistryInfo.of(class_7924.field_41206, class_4140.class);
    public static final RegistryInfo<class_4149> SENSOR_TYPE = RegistryInfo.of(class_7924.field_41221, class_4149.class);
    public static final RegistryInfo<class_4170> SCHEDULE = RegistryInfo.of(class_7924.field_41220, class_4170.class);
    public static final RegistryInfo<class_4168> ACTIVITY = RegistryInfo.of(class_7924.field_41222, class_4168.class);
    public static final RegistryInfo<class_5338> LOOT_ENTRY = RegistryInfo.of(class_7924.field_41202, class_5338.class);
    public static final RegistryInfo<class_5339> LOOT_FUNCTION = RegistryInfo.of(class_7924.field_41199, class_5339.class);
    public static final RegistryInfo<class_5342> LOOT_ITEM = RegistryInfo.of(class_7924.field_41198, class_5342.class);
    public static final RegistryInfo<class_5657> LOOT_NUMBER_PROVIDER = RegistryInfo.of(class_7924.field_41201, class_5657.class);
    public static final RegistryInfo<class_5650> LOOT_NBT_PROVIDER = RegistryInfo.of(class_7924.field_41200, class_5650.class);
    public static final RegistryInfo<class_5669> LOOT_SCORE_PROVIDER = RegistryInfo.of(class_7924.field_41203, class_5669.class);
    public static final RegistryInfo<class_2314> COMMAND_ARGUMENT_TYPE = RegistryInfo.of(class_7924.field_41262, class_2314.class);
    public static final RegistryInfo<class_2874> DIMENSION_TYPE = RegistryInfo.of(class_7924.field_41241, class_2874.class);
    public static final RegistryInfo<class_1937> DIMENSION = RegistryInfo.of(class_7924.field_41223, class_1937.class);
    public static final RegistryInfo<class_5363> LEVEL_STEM = RegistryInfo.of(class_7924.field_41224, class_5363.class);
    public static final RegistryInfo<class_5864> FLOAT_PROVIDER_TYPE = RegistryInfo.of(class_7924.field_41269, class_5864.class);
    public static final RegistryInfo<class_6018> INT_PROVIDER_TYPE = RegistryInfo.of(class_7924.field_41196, class_6018.class);
    public static final RegistryInfo<class_6123> HEIGHT_PROVIDER_TYPE = RegistryInfo.of(class_7924.field_41274, class_6123.class);
    public static final RegistryInfo<class_6647> BLOCK_PREDICATE_TYPE = RegistryInfo.of(class_7924.field_41256, class_6647.class);
    public static final RegistryInfo<class_5284> NOISE_GENERATOR_SETTINGS = RegistryInfo.of(class_7924.field_41243, class_5284.class);
    public static final RegistryInfo<class_2922> CONFIGURED_CARVER = RegistryInfo.of(class_7924.field_41238, class_2922.class);
    public static final RegistryInfo<class_2975> CONFIGURED_FEATURE = RegistryInfo.of(class_7924.field_41239, class_2975.class);
    public static final RegistryInfo<class_6796> PLACED_FEATURE = RegistryInfo.of(class_7924.field_41245, class_6796.class);
    public static final RegistryInfo<class_3195> STRUCTURE = RegistryInfo.of(class_7924.field_41246, class_3195.class);
    public static final RegistryInfo<class_7059> STRUCTURE_SET = RegistryInfo.of(class_7924.field_41248, class_7059.class);
    public static final RegistryInfo<class_5497> PROCESSOR_LIST = RegistryInfo.of(class_7924.field_41247, class_5497.class);
    public static final RegistryInfo<class_3785> TEMPLATE_POOL = RegistryInfo.of(class_7924.field_41249, class_3785.class);
    public static final RegistryInfo<class_1959> BIOME = RegistryInfo.of(class_7924.field_41236, class_1959.class);
    public static final RegistryInfo<class_5216.class_5487> NOISE = RegistryInfo.of(class_7924.field_41244, class_5216.class_5487.class);
    public static final RegistryInfo<class_6910> DENSITY_FUNCTION = RegistryInfo.of(class_7924.field_41240, class_6910.class);
    public static final RegistryInfo<class_7145> WORLD_PRESET = RegistryInfo.of(class_7924.field_41250, class_7145.class);
    public static final RegistryInfo<class_7142> FLAT_LEVEL_GENERATOR_PRESET = RegistryInfo.of(class_7924.field_41242, class_7142.class);
    public static final RegistryInfo<class_2939> CARVER = RegistryInfo.of(class_7924.field_41258, class_2939.class);
    public static final RegistryInfo<class_3031> FEATURE = RegistryInfo.of(class_7924.field_41267, class_3031.class);
    public static final RegistryInfo<class_6875> STRUCTURE_PLACEMENT_TYPE = RegistryInfo.of(class_7924.field_41228, class_6875.class);
    public static final RegistryInfo<class_3773> STRUCTURE_PIECE = RegistryInfo.of(class_7924.field_41227, class_3773.class);
    public static final RegistryInfo<class_7151> STRUCTURE_TYPE = RegistryInfo.of(class_7924.field_41231, class_7151.class);
    public static final RegistryInfo<class_6798> PLACEMENT_MODIFIER = RegistryInfo.of(class_7924.field_41211, class_6798.class);
    public static final RegistryInfo<class_4652> BLOCK_STATE_PROVIDER_TYPE = RegistryInfo.of(class_7924.field_41257, class_4652.class);
    public static final RegistryInfo<class_4648> FOLIAGE_PLACER_TYPE = RegistryInfo.of(class_7924.field_41271, class_4648.class);
    public static final RegistryInfo<class_5142> TRUNK_PLACER_TYPE = RegistryInfo.of(class_7924.field_41233, class_5142.class);
    public static final RegistryInfo<class_4663> TREE_DECORATOR_TYPE = RegistryInfo.of(class_7924.field_41232, class_4663.class);
    public static final RegistryInfo<class_7388> ROOT_PLACER_TYPE = RegistryInfo.of(class_7924.field_41218, class_7388.class);
    public static final RegistryInfo<class_5202> FEATURE_SIZE_TYPE = RegistryInfo.of(class_7924.field_41268, class_5202.class);
    public static final RegistryInfo<Codec> BIOME_SOURCE = RegistryInfo.of(class_7924.field_41253, Codec.class);
    public static final RegistryInfo<Codec> CHUNK_GENERATOR = RegistryInfo.of(class_7924.field_41260, Codec.class);
    public static final RegistryInfo<Codec> CONDITION = RegistryInfo.of(class_7924.field_41204, Codec.class);
    public static final RegistryInfo<Codec> RULE = RegistryInfo.of(class_7924.field_41205, Codec.class);
    public static final RegistryInfo<Codec> DENSITY_FUNCTION_TYPE = RegistryInfo.of(class_7924.field_41264, Codec.class);
    public static final RegistryInfo<class_3828> STRUCTURE_PROCESSOR = RegistryInfo.of(class_7924.field_41230, class_3828.class);
    public static final RegistryInfo<class_3816> STRUCTURE_POOL_ELEMENT = RegistryInfo.of(class_7924.field_41229, class_3816.class);
    public static final RegistryInfo<class_2556> CHAT_TYPE = RegistryInfo.of(class_7924.field_41237, class_2556.class);
    public static final RegistryInfo<class_7375> CAT_VARIANT = RegistryInfo.of(class_7924.field_41259, class_7375.class);
    public static final RegistryInfo<class_7106> FROG_VARIANT = RegistryInfo.of(class_7924.field_41272, class_7106.class);
    public static final RegistryInfo<class_2582> BANNER_PATTERN = RegistryInfo.of(class_7924.field_41252, class_2582.class);
    public static final RegistryInfo<class_7444> INSTRUMENT = RegistryInfo.of(class_7924.field_41275, class_7444.class);
    public static final RegistryInfo<class_8054> TRIM_MATERIAL = RegistryInfo.of(class_7924.field_42083, class_8054.class);
    public static final RegistryInfo<class_8056> TRIM_PATTERN = RegistryInfo.of(class_7924.field_42082, class_8056.class);
    public static final RegistryInfo<class_1761> CREATIVE_MODE_TAB = RegistryInfo.of(class_7924.field_44688, class_1761.class);
    public static final RegistryInfo<class_8110> DAMAGE_TYPE = RegistryInfo.of(class_7924.field_42534, class_8110.class);
    public static final RegistryInfo<class_5342> LOOT_CONDITION_TYPE = RegistryInfo.of(class_7924.field_41198, class_5342.class);
    public static final RegistryInfo<class_5339> LOOT_FUNCTION_TYPE = RegistryInfo.of(class_7924.field_41199, class_5339.class);
    public static final RegistryInfo<class_5650> LOOT_NBT_PROVIDER_TYPE = RegistryInfo.of(class_7924.field_41200, class_5650.class);
    public static final RegistryInfo<class_5657> LOOT_NUMBER_PROVIDER_TYPE = RegistryInfo.of(class_7924.field_41201, class_5657.class);
    public static final RegistryInfo<class_5338> LOOT_POOL_ENTRY_TYPE = RegistryInfo.of(class_7924.field_41202, class_5338.class);
    public static final RegistryInfo<class_5669> LOOT_SCORE_PROVIDER_TYPE = RegistryInfo.of(class_7924.field_41203, class_5669.class);
    public static final RegistryInfo<Codec> MATERIAL_CONDITION = RegistryInfo.of(class_7924.field_41204, Codec.class);
    public static final RegistryInfo<Codec> MATERIAL_RULE = RegistryInfo.of(class_7924.field_41205, Codec.class);
    public static final RegistryInfo<class_6798> PLACEMENT_MODIFIER_TYPE = RegistryInfo.of(class_7924.field_41211, class_6798.class);
    public static final RegistryInfo<class_8249> RULE_BLOCK_ENTITY_MODIFIER = RegistryInfo.of(class_7924.field_43382, class_8249.class);
    public static final RegistryInfo<class_6875> STRUCTURE_PLACEMENT = RegistryInfo.of(class_7924.field_41228, class_6875.class);
    public static final RegistryInfo<String> DECORATED_POT_PATTERNS = RegistryInfo.of(class_7924.field_42941, String.class);
    public static final RegistryInfo<class_5284> NOISE_SETTINGS = RegistryInfo.of(class_7924.field_41243, class_5284.class);
    public static final RegistryInfo<class_8197> MULTI_NOISE_BIOME_SOURCE_PARAMETER_LIST = RegistryInfo.of(class_7924.field_43089, class_8197.class);
    public static final LinkedList<RegistryInfo<?>> AFTER_VANILLA = new LinkedList();
    public final class_5321<? extends class_2378<T>> key;
    public final Class<?> objectBaseClass;
    public final Map<String, BuilderType<T>> types;
    public final Map<class_2960, BuilderBase<? extends T>> objects;
    public boolean hasDefaultTags = false;
    private BuilderType<T> defaultType;
    public boolean bypassServerOnly;
    public boolean autoWrap;
    private Registrar<T> architecturyRegistrar;
    public String languageKeyPrefix;

    public static <T> RegistryInfo<T> of(class_5321<? extends class_2378<?>> key, Class<T> type) {
        RegistryInfo<?> r = MAP.get(key);
        if (r == null) {
            RegistryInfo<T> reg = new RegistryInfo<T>((class_5321)UtilsJS.cast(key), type);
            MAP.put(key, reg);
            return reg;
        }
        return r;
    }

    public static RegistryInfo<?> of(class_5321<? extends class_2378<?>> key) {
        return RegistryInfo.of((class_5321)UtilsJS.cast(key), Object.class);
    }

    private RegistryInfo(class_5321<? extends class_2378<T>> key, Class<T> objectBaseClass) {
        this.key = key;
        this.objectBaseClass = objectBaseClass;
        this.types = new LinkedHashMap<String, BuilderType<T>>();
        this.objects = new LinkedHashMap<class_2960, BuilderBase<? extends T>>();
        this.bypassServerOnly = false;
        this.autoWrap = objectBaseClass != Codec.class && objectBaseClass != class_2960.class && objectBaseClass != String.class;
        this.languageKeyPrefix = key.method_29177().method_12832().replace('/', '.');
    }

    public RegistryInfo<T> bypassServerOnly() {
        this.bypassServerOnly = true;
        return this;
    }

    public RegistryInfo<T> noAutoWrap() {
        this.autoWrap = false;
        return this;
    }

    public RegistryInfo<T> languageKeyPrefix(String prefix) {
        this.languageKeyPrefix = prefix;
        return this;
    }

    public void addType(String type, Class<? extends BuilderBase<? extends T>> builderType, BuilderFactory factory, boolean isDefault) {
        BuilderType b = new BuilderType(type, builderType, factory);
        this.types.put(type, b);
        if (isDefault) {
            if (this.defaultType != null) {
                ConsoleJS.STARTUP.warn("Previous default type '" + this.defaultType.type() + "' for registry '" + String.valueOf(this.key.method_29177()) + "' replaced with '" + type + "'!");
            }
            this.defaultType = b;
        }
    }

    public void addType(String type, Class<? extends BuilderBase<? extends T>> builderType, BuilderFactory factory) {
        this.addType(type, builderType, factory, type.equals("basic"));
    }

    public void addBuilder(BuilderBase<? extends T> builder) {
        if (builder == null) {
            throw new IllegalArgumentException("Can't add null builder in registry '" + String.valueOf(this.key.method_29177()) + "'!");
        }
        if (DevProperties.get().debugInfo) {
            ConsoleJS.STARTUP.info("~ " + String.valueOf(this.key.method_29177()) + " | " + String.valueOf(builder.id));
        }
        if (this.objects.containsKey(builder.id)) {
            throw new IllegalArgumentException("Duplicate key '" + String.valueOf(builder.id) + "' in registry '" + String.valueOf(this.key.method_29177()) + "'!");
        }
        this.objects.put(builder.id, builder);
        ALL_BUILDERS.add(builder);
    }

    @Nullable
    public BuilderType getDefaultType() {
        if (this.types.isEmpty()) {
            return null;
        }
        if (this.defaultType == null) {
            this.defaultType = this.types.values().iterator().next();
        }
        return this.defaultType;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == this) return true;
        if (!(obj instanceof RegistryInfo)) return false;
        RegistryInfo ri = (RegistryInfo)obj;
        if (!this.key.equals(ri.key)) return false;
        return true;
    }

    public String toString() {
        return this.key.method_29177().toString();
    }

    public int registerObjects(RegistryCallback<T> function) {
        if (DevProperties.get().debugInfo) {
            if (this.objects.isEmpty()) {
                KubeJS.LOGGER.info("Skipping " + String.valueOf(this) + " registry");
            } else {
                KubeJS.LOGGER.info("Building " + this.objects.size() + " objects of " + String.valueOf(this) + " registry");
            }
        }
        if (this.objects.isEmpty()) {
            return 0;
        }
        int added = 0;
        for (BuilderBase<T> builder : this) {
            if (builder.dummyBuilder) continue;
            if (!builder.getRegistryType().bypassServerOnly) {
                if (CommonProperties.get().serverOnly) continue;
            }
            function.accept(builder.id, builder::createTransformedObject);
            if (DevProperties.get().debugInfo) {
                ConsoleJS.STARTUP.info("+ " + String.valueOf(this) + " | " + String.valueOf(builder.id));
            }
            ++added;
        }
        if (!this.objects.isEmpty() && DevProperties.get().debugInfo) {
            KubeJS.LOGGER.info("Registered " + added + "/" + this.objects.size() + " objects of " + String.valueOf(this));
        }
        return added;
    }

    @Override
    @NotNull
    public Iterator<BuilderBase<? extends T>> iterator() {
        return this.objects.values().iterator();
    }

    public Registrar<T> getArchitecturyRegistrar() {
        if (this.architecturyRegistrar == null) {
            this.architecturyRegistrar = REGISTRIES.get(this.key);
        }
        return this.architecturyRegistrar;
    }

    public class_2378<T> getVanillaRegistry() {
        return (class_2378)class_7923.field_41167.method_29107(this.key);
    }

    public Set<Map.Entry<class_5321<T>, T>> entrySet() {
        return this.getArchitecturyRegistrar().entrySet();
    }

    public class_2960 getId(T value) {
        return this.getArchitecturyRegistrar().getId(value);
    }

    public T getValue(class_2960 id) {
        return (T)this.getArchitecturyRegistrar().get(id);
    }

    public boolean hasValue(class_2960 id) {
        return this.getArchitecturyRegistrar().contains(id);
    }

    public T wrap(Context cx, Object o) {
        if (o == null) {
            return null;
        }
        if (this.objectBaseClass.isInstance(o)) {
            return (T)o;
        }
        class_2960 id = UtilsJS.getMCID(cx, o);
        T value = this.getValue(id);
        if (value == null) {
            NullPointerException npe = new NullPointerException("No such element with id %s in registry %s!".formatted(id, this));
            ConsoleJS.getCurrent(cx).error("Error while wrapping registry element type!", npe);
            throw npe;
        }
        return value;
    }

    public void fireRegistryEvent() {
        RegistryEventJS event = new RegistryEventJS(this);
        StartupEvents.REGISTRY.post(event, this.key);
        event.created.forEach(BuilderBase::createAdditionalObjects);
    }
}

