/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.immersiveengineering.recipe;

import blusunrize.immersiveengineering.api.crafting.builders.ThermoelectricSourceBuilder;
import dev.latvian.mods.kubejs.immersiveengineering.recipe.IERecipeJS;
import dev.latvian.mods.kubejs.immersiveengineering.recipe.IERecipes;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.recipe.RecipeKey;
import dev.latvian.mods.kubejs.recipe.component.NumberComponent;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchema;

public interface ThermoelectricSourceSchema {
    public static final RecipeKey<IERecipes.HeatSource> HEAT_SOURCE = IERecipes.HEAT_SOURCE_COMPONENT.key("heat_source");
    public static final RecipeKey<Integer> TEMPERATURE = NumberComponent.INT.key("tempKelvin");
    public static final RecipeSchema SCHEMA = new RecipeSchema(ThermoelectricSourceRecipeJS.class, ThermoelectricSourceRecipeJS::new, new RecipeKey[]{HEAT_SOURCE, TEMPERATURE});

    public static class ThermoelectricSourceRecipeJS
    extends IERecipeJS {
        public RecipeJS kelvin(int temp) {
            return this.setValue(TEMPERATURE, temp);
        }

        public RecipeJS celsius(int temp) {
            return this.kelvin(ThermoelectricSourceBuilder.TemperatureScale.CELSIUS.toKelvin(temp));
        }

        public RecipeJS fahrenheit(int temp) {
            return this.kelvin(ThermoelectricSourceBuilder.TemperatureScale.FAHRENHEIT.toKelvin(temp));
        }
    }
}

