/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.mekanism.custom;

import dev.latvian.kubejs.mekanism.MekanismKubeJSPlugin;
import dev.latvian.kubejs.mekanism.custom.KubeJSChemicalBuilder;
import dev.latvian.mods.kubejs.registry.RegistryInfo;
import dev.latvian.mods.kubejs.util.Tags;
import java.util.function.Supplier;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryBuilder;
import net.minecraft.resources.ResourceLocation;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class KubeJSSlurryBuilder
extends KubeJSChemicalBuilder<Slurry, SlurryBuilder, KubeJSSlurryBuilder> {
    public KubeJSSlurryBuilder(ResourceLocation id) {
        super(id);
    }

    public KubeJSSlurryBuilder ore(ResourceLocation ore) {
        return this.oreTag(ore);
    }

    public KubeJSSlurryBuilder oreTag(ResourceLocation ore) {
        ((SlurryBuilder)this.builder()).ore(Tags.item((ResourceLocation)ore));
        return (KubeJSSlurryBuilder)((Object)this.self());
    }

    public RegistryInfo getRegistryType() {
        return MekanismKubeJSPlugin.SLURRY;
    }

    public Slurry createObject() {
        if (this.barColor == null) {
            return new Slurry((SlurryBuilder)this.builder());
        }
        final int color = this.barColor;
        return new Slurry((SlurryBuilder)this.builder()){

            public int getColorRepresentation() {
                return color;
            }
        };
    }

    public static final class Clean
    extends KubeJSSlurryBuilder {
        public Clean(ResourceLocation id) {
            super(id);
        }

        @Override
        protected Supplier<SlurryBuilder> bindBuilder() {
            return SlurryBuilder::clean;
        }
    }

    public static final class Dirty
    extends KubeJSSlurryBuilder {
        public Dirty(ResourceLocation id) {
            super(id);
        }

        @Override
        protected Supplier<SlurryBuilder> bindBuilder() {
            return SlurryBuilder::dirty;
        }
    }

    public static final class Basic
    extends KubeJSSlurryBuilder {
        private ResourceLocation texture = null;

        public Basic(ResourceLocation id) {
            super(id);
        }

        @Override
        protected Supplier<SlurryBuilder> bindBuilder() {
            return () -> {
                if (this.texture == null) {
                    throw new IllegalStateException("ERROR: Texture is required for 'basic' slurries! Please use builder.texture(...) to set it.");
                }
                return SlurryBuilder.builder((ResourceLocation)this.texture);
            };
        }

        public Basic texture(ResourceLocation texture) {
            this.texture = texture;
            return this;
        }
    }
}

