/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.component;

import dev.latvian.mods.kubejs.color.KubeColor;
import dev.latvian.mods.kubejs.component.AttributeModifierFunctions;
import dev.latvian.mods.kubejs.component.ComponentFunctions;
import dev.latvian.mods.rhino.util.HideFromJS;
import dev.latvian.mods.rhino.util.RemapPrefixForJS;
import dev.latvian.mods.rhino.util.ReturnsSelf;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Unit;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Instrument;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.BundleContents;
import net.minecraft.world.item.component.ChargedProjectiles;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.component.Fireworks;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.MapItemColor;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.component.Unbreakable;
import org.jetbrains.annotations.Nullable;

@RemapPrefixForJS(value="kjs$")
@ReturnsSelf
public interface ItemComponentFunctions
extends ComponentFunctions,
AttributeModifierFunctions {
    @HideFromJS
    default public <T> ItemComponentFunctions kjs$overrideItem(DataComponentType<T> type, @Nullable T value) {
        this.kjs$override(type, value);
        return this;
    }

    default public ItemComponentFunctions kjs$setMaxStackSize(int size) {
        return this.kjs$overrideItem(DataComponents.MAX_STACK_SIZE, size);
    }

    default public ItemComponentFunctions kjs$setMaxDamage(int maxDamage) {
        return this.kjs$overrideItem(DataComponents.MAX_DAMAGE, maxDamage);
    }

    default public ItemComponentFunctions kjs$setDamage(int damage) {
        return this.kjs$overrideItem(DataComponents.DAMAGE, damage);
    }

    default public ItemComponentFunctions kjs$setUnbreakable() {
        return this.kjs$overrideItem(DataComponents.UNBREAKABLE, new Unbreakable(false));
    }

    default public ItemComponentFunctions kjs$setUnbreakableWithTooltip() {
        return this.kjs$overrideItem(DataComponents.UNBREAKABLE, new Unbreakable(true));
    }

    default public ItemComponentFunctions kjs$setItemName(Component component) {
        return this.kjs$overrideItem(DataComponents.ITEM_NAME, component);
    }

    default public ItemComponentFunctions kjs$setRepairCost(int repairCost) {
        return this.kjs$overrideItem(DataComponents.REPAIR_COST, repairCost);
    }

    default public ItemComponentFunctions kjs$setFood(FoodProperties foodProperties) {
        return this.kjs$overrideItem(DataComponents.FOOD, foodProperties);
    }

    default public ItemComponentFunctions kjs$setFood(int nutrition, float saturation) {
        return this.kjs$setFood(new FoodProperties.Builder().nutrition(nutrition).saturationModifier(saturation).build());
    }

    default public ItemComponentFunctions kjs$setFireResistant() {
        this.kjs$setUnit((DataComponentType<Unit>)DataComponents.FIRE_RESISTANT);
        return this;
    }

    default public ItemComponentFunctions kjs$setTool(Tool tool) {
        return this.kjs$overrideItem(DataComponents.TOOL, tool);
    }

    default public ItemComponentFunctions kjs$setMapItemColor(KubeColor color) {
        return this.kjs$overrideItem(DataComponents.MAP_COLOR, new MapItemColor(color.kjs$getRGB()));
    }

    default public ItemComponentFunctions kjs$setChargedProjectiles(List<ItemStack> items) {
        return this.kjs$overrideItem(DataComponents.CHARGED_PROJECTILES, ChargedProjectiles.of(items));
    }

    default public ItemComponentFunctions kjs$setBundleContents(List<ItemStack> items) {
        return this.kjs$overrideItem(DataComponents.BUNDLE_CONTENTS, new BundleContents(items));
    }

    default public ItemComponentFunctions kjs$setBucketEntityData(CompoundTag tag) {
        return this.kjs$overrideItem(DataComponents.BUCKET_ENTITY_DATA, CustomData.of((CompoundTag)tag));
    }

    default public ItemComponentFunctions kjs$setBlockEntityData(CompoundTag tag) {
        return this.kjs$overrideItem(DataComponents.BLOCK_ENTITY_DATA, CustomData.of((CompoundTag)tag));
    }

    default public ItemComponentFunctions kjs$setInstrument(Holder<Instrument> instrument) {
        return this.kjs$overrideItem(DataComponents.INSTRUMENT, instrument);
    }

    default public ItemComponentFunctions kjs$setFireworkExplosion(FireworkExplosion explosion) {
        return this.kjs$overrideItem(DataComponents.FIREWORK_EXPLOSION, explosion);
    }

    default public ItemComponentFunctions kjs$setFireworks(Fireworks fireworks) {
        return this.kjs$overrideItem(DataComponents.FIREWORKS, fireworks);
    }

    default public ItemComponentFunctions kjs$setNoteBlockSound(ResourceLocation id) {
        return this.kjs$overrideItem(DataComponents.NOTE_BLOCK_SOUND, id);
    }

    @Override
    default public ItemAttributeModifiers kjs$getAttributeModifiers() {
        ItemAttributeModifiers mods = (ItemAttributeModifiers)this.kjs$get(DataComponents.ATTRIBUTE_MODIFIERS);
        return mods == null ? new ItemAttributeModifiers(List.of(), true) : mods;
    }

    @Override
    default public ItemComponentFunctions kjs$setAttributeModifiers(ItemAttributeModifiers modifiers) {
        return this.kjs$overrideItem(DataComponents.ATTRIBUTE_MODIFIERS, modifiers);
    }
}

