/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe;

import dev.latvian.mods.kubejs.recipe.KubeRecipe;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponentValue;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponentValueFunction;
import dev.latvian.mods.kubejs.recipe.schema.function.RecipeFunctionInstance;
import dev.latvian.mods.kubejs.recipe.schema.function.RecipeSchemaJSFunction;
import dev.latvian.mods.rhino.BaseFunction;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.NativeJavaObject;
import dev.latvian.mods.rhino.Scriptable;
import dev.latvian.mods.rhino.type.TypeInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RecipeFunction
extends NativeJavaObject {
    public final KubeRecipe recipe;
    public final Map<String, BaseFunction> builderFunctions;

    public static boolean isValidIdentifier(char[] name) {
        if (name.length == 0 || !Character.isJavaIdentifierStart(name[0])) {
            return false;
        }
        for (int i = 1; i < name.length; ++i) {
            if (Character.isJavaIdentifierPart(name[i])) continue;
            return false;
        }
        return true;
    }

    public RecipeFunction(Context cx, Scriptable scope, TypeInfo staticType, KubeRecipe recipe) {
        super(scope, (Object)recipe, staticType, cx);
        this.recipe = recipe;
        this.builderFunctions = new HashMap<String, BaseFunction>();
        for (RecipeComponentValue<?> value : recipe.getRecipeComponentValues()) {
            List<String> names = value.key.getValidFunctionNames();
            if (names.isEmpty()) continue;
            RecipeComponentValueFunction func = new RecipeComponentValueFunction(recipe, value);
            for (String name : names) {
                this.builderFunctions.put(name, func);
            }
        }
        for (RecipeFunctionInstance func : recipe.type.schemaType.schema.functions.values()) {
            if (!RecipeFunction.isValidIdentifier(func.name().toCharArray())) continue;
            this.builderFunctions.put(func.name(), new RecipeSchemaJSFunction(recipe, (TypeInfo[])func.arguments().stream().map(RecipeComponent::typeInfo).toArray(TypeInfo[]::new), func.function()));
        }
    }

    public Object get(Context cx, String name, Scriptable start) {
        BaseFunction r;
        Object s = super.get(cx, name, start);
        if (s == Scriptable.NOT_FOUND && (r = this.builderFunctions.get(name)) != null) {
            return r;
        }
        return s;
    }
}

