/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.thermal;

import cofh.thermal.core.util.managers.dynamo.CompressionFuelManager;
import cofh.thermal.core.util.managers.dynamo.DisenchantmentFuelManager;
import cofh.thermal.core.util.managers.dynamo.GourmandFuelManager;
import cofh.thermal.core.util.managers.dynamo.LapidaryFuelManager;
import cofh.thermal.core.util.managers.dynamo.MagmaticFuelManager;
import cofh.thermal.core.util.managers.dynamo.NumismaticFuelManager;
import cofh.thermal.core.util.managers.dynamo.StirlingFuelManager;
import com.mojang.datafixers.util.Either;
import dev.latvian.mods.kubejs.fluid.InputFluid;
import dev.latvian.mods.kubejs.item.InputItem;
import dev.latvian.mods.kubejs.recipe.RecipeKey;
import dev.latvian.mods.kubejs.recipe.component.FluidComponents;
import dev.latvian.mods.kubejs.recipe.component.NumberComponent;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchema;
import dev.latvian.mods.kubejs.thermal.ThermalRecipeJS;

public interface FuelRecipeSchema {
    public static final RecipeKey<Either<InputFluid, InputItem>[]> INPUT = FluidComponents.INPUT_OR_ITEM_ARRAY.key("ingredients").alt(new String[]{"ingredient", "input", "inputs"});
    public static final RecipeKey<Integer> ITEM_FUEL_ENERGY = NumberComponent.intRange((int)1000, (int)20000000).key("energy").optional(type -> switch (type.id.m_135815_()) {
        case "stirling_fuel" -> StirlingFuelManager.instance().getDefaultEnergy();
        case "numismatic_fuel" -> NumismaticFuelManager.instance().getDefaultEnergy();
        case "lapidary_fuel" -> LapidaryFuelManager.instance().getDefaultEnergy();
        case "disenchantment_fuel" -> DisenchantmentFuelManager.instance().getDefaultEnergy();
        case "gourmand_fuel" -> GourmandFuelManager.instance().getDefaultEnergy();
        default -> 0;
    });
    public static final RecipeKey<Integer> FLUID_FUEL_ENERGY = NumberComponent.intRange((int)10000, (int)200000000).key("energy").optional(type -> switch (type.id.m_135815_()) {
        case "compression_fuel" -> CompressionFuelManager.instance().getDefaultEnergy();
        case "magmatic_fuel" -> MagmaticFuelManager.instance().getDefaultEnergy();
        default -> 0;
    });
    public static final RecipeKey<Float> ENERGY_MOD = NumberComponent.FLOAT.key("energy_mod").optional((Object)Float.valueOf(1.0f)).exclude().preferred("energyMod");
    public static final RecipeSchema ITEM_FUEL = new RecipeSchema(ThermalRecipeJS.class, ThermalRecipeJS::new, new RecipeKey[]{INPUT, ITEM_FUEL_ENERGY, ENERGY_MOD});
    public static final RecipeSchema FLUID_FUEL = new RecipeSchema(ThermalRecipeJS.class, ThermalRecipeJS::new, new RecipeKey[]{INPUT, FLUID_FUEL_ENERGY, ENERGY_MOD});
}

