/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino;

import dev.latvian.mods.rhino.ConsString;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.ScriptRuntime;
import dev.latvian.mods.rhino.Undefined;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class Hashtable
implements Iterable<Entry> {
    private final Context localContext;
    private final HashMap<Object, Entry> map = new HashMap();
    private Entry first = null;
    private Entry last = null;

    private static Entry makeDummy(Context cx) {
        Entry d = new Entry(cx);
        d.clear();
        return d;
    }

    public Hashtable(Context cx) {
        this.localContext = cx;
    }

    public int size() {
        return this.map.size();
    }

    public void put(Context cx, Object key, Object value) {
        Entry nv = new Entry(cx, key, value);
        Entry ev = this.map.putIfAbsent(nv, nv);
        if (ev == null) {
            if (this.first == null) {
                this.first = this.last = nv;
            } else {
                this.last.next = nv;
                nv.prev = this.last;
                this.last = nv;
            }
        } else {
            ev.value = value;
        }
    }

    public Object get(Context cx, Object key) {
        Entry e = new Entry(cx, key, null);
        Entry v = this.map.get(e);
        if (v == null) {
            return null;
        }
        return v.value;
    }

    public boolean has(Context cx, Object key) {
        Entry e = new Entry(cx, key, null);
        return this.map.containsKey(e);
    }

    public Object delete(Context cx, Object key) {
        Entry e = new Entry(cx, key, null);
        Entry v = this.map.remove(e);
        if (v == null) {
            return null;
        }
        if (v == this.first) {
            if (v == this.last) {
                v.clear();
                v.prev = null;
            } else {
                this.first = v.next;
                this.first.prev = null;
                if (this.first.next != null) {
                    this.first.next.prev = this.first;
                }
            }
        } else {
            Entry prev = v.prev;
            prev.next = v.next;
            v.prev = null;
            if (v.next != null) {
                v.next.prev = prev;
            } else {
                assert (v == this.last);
                this.last = prev;
            }
        }
        return v.clear();
    }

    public void clear(Context cx) {
        Iterator<Entry> it = this.iterator();
        it.forEachRemaining(Entry::clear);
        if (this.first != null) {
            Entry dummy;
            this.last.next = dummy = Hashtable.makeDummy(cx);
            this.first = this.last = dummy;
        }
        this.map.clear();
    }

    @Override
    public Iterator<Entry> iterator() {
        return new Iter(this.localContext, this.first);
    }

    public static final class Entry {
        private final Context localContext;
        private final int hashCode;
        Object key;
        Object value;
        private boolean deleted;
        private Entry next;
        private Entry prev;

        Entry(Context cx) {
            this.localContext = cx;
            this.hashCode = 0;
        }

        Entry(Context cx, Object k, Object value) {
            this.localContext = cx;
            this.key = k instanceof Number && !(k instanceof Double) ? Double.valueOf(((Number)k).doubleValue()) : (k instanceof ConsString ? k.toString() : k);
            this.hashCode = this.key == null ? 0 : (k.equals(ScriptRuntime.negativeZeroObj) ? 0 : this.key.hashCode());
            this.value = value;
        }

        public Object key() {
            return this.key;
        }

        public Object value() {
            return this.value;
        }

        Object clear() {
            Object ret = this.value;
            this.key = Undefined.INSTANCE;
            this.value = Undefined.INSTANCE;
            this.deleted = true;
            return ret;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            try {
                return ScriptRuntime.sameZero(this.localContext, this.key, ((Entry)o).key);
            }
            catch (ClassCastException cce) {
                return false;
            }
        }
    }

    private static final class Iter
    implements Iterator<Entry> {
        private Entry pos;

        Iter(Context cx, Entry start) {
            Entry dummy = Hashtable.makeDummy(cx);
            dummy.next = start;
            this.pos = dummy;
        }

        private void skipDeleted() {
            while (this.pos.next != null && this.pos.next.deleted) {
                this.pos = this.pos.next;
            }
        }

        @Override
        public boolean hasNext() {
            this.skipDeleted();
            return this.pos != null && this.pos.next != null;
        }

        @Override
        public Entry next() {
            this.skipDeleted();
            if (this.pos == null || this.pos.next == null) {
                throw new NoSuchElementException();
            }
            Entry e = this.pos.next;
            this.pos = this.pos.next;
            return e;
        }
    }
}

