/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino;

import dev.latvian.mods.rhino.ArrowFunction;
import dev.latvian.mods.rhino.BaseFunction;
import dev.latvian.mods.rhino.Callable;
import dev.latvian.mods.rhino.CodeGenerator;
import dev.latvian.mods.rhino.CompilerEnvirons;
import dev.latvian.mods.rhino.ConsString;
import dev.latvian.mods.rhino.ConstProperties;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.ES6Generator;
import dev.latvian.mods.rhino.EcmaError;
import dev.latvian.mods.rhino.EqualObjectGraphs;
import dev.latvian.mods.rhino.Evaluator;
import dev.latvian.mods.rhino.EvaluatorException;
import dev.latvian.mods.rhino.Function;
import dev.latvian.mods.rhino.GeneratorState;
import dev.latvian.mods.rhino.Icode;
import dev.latvian.mods.rhino.IdEnumeration;
import dev.latvian.mods.rhino.IdFunctionObject;
import dev.latvian.mods.rhino.InterpretedFunction;
import dev.latvian.mods.rhino.InterpreterData;
import dev.latvian.mods.rhino.JavaScriptException;
import dev.latvian.mods.rhino.Kit;
import dev.latvian.mods.rhino.NativeIterator;
import dev.latvian.mods.rhino.NativeWith;
import dev.latvian.mods.rhino.ObjArray;
import dev.latvian.mods.rhino.Ref;
import dev.latvian.mods.rhino.RhinoException;
import dev.latvian.mods.rhino.Script;
import dev.latvian.mods.rhino.ScriptRuntime;
import dev.latvian.mods.rhino.ScriptStackElement;
import dev.latvian.mods.rhino.Scriptable;
import dev.latvian.mods.rhino.ScriptableObject;
import dev.latvian.mods.rhino.Undefined;
import dev.latvian.mods.rhino.UniqueTag;
import dev.latvian.mods.rhino.Wrapper;
import dev.latvian.mods.rhino.ast.ScriptNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class Interpreter
extends Icode
implements Evaluator {
    static final int EXCEPTION_TRY_START_SLOT = 0;
    static final int EXCEPTION_TRY_END_SLOT = 1;
    static final int EXCEPTION_HANDLER_SLOT = 2;
    static final int EXCEPTION_TYPE_SLOT = 3;
    static final int EXCEPTION_LOCAL_SLOT = 4;
    static final int EXCEPTION_SCOPE_SLOT = 5;
    static final int EXCEPTION_SLOT_SIZE = 6;
    InterpreterData itsData;

    private static boolean compareIdata(InterpreterData i1, InterpreterData i2) {
        return i1 == i2;
    }

    private static CallFrame captureFrameForGenerator(CallFrame frame) {
        frame.frozen = true;
        CallFrame result = frame.cloneFrozen();
        frame.frozen = false;
        result.parentFrame = null;
        result.frameIndex = 0;
        return result;
    }

    private static int getShort(byte[] iCode, int pc) {
        return iCode[pc] << 8 | iCode[pc + 1] & 0xFF;
    }

    private static int getIndex(byte[] iCode, int pc) {
        return (iCode[pc] & 0xFF) << 8 | iCode[pc + 1] & 0xFF;
    }

    private static int getInt(byte[] iCode, int pc) {
        return iCode[pc] << 24 | (iCode[pc + 1] & 0xFF) << 16 | (iCode[pc + 2] & 0xFF) << 8 | iCode[pc + 3] & 0xFF;
    }

    private static int getExceptionHandler(CallFrame frame, boolean onlyFinally) {
        int[] exceptionTable = frame.idata.itsExceptionTable;
        if (exceptionTable == null) {
            return -1;
        }
        int pc = frame.pc - 1;
        int best = -1;
        int bestStart = 0;
        int bestEnd = 0;
        for (int i = 0; i != exceptionTable.length; i += 6) {
            int start = exceptionTable[i + 0];
            int end = exceptionTable[i + 1];
            if (start > pc || pc >= end || onlyFinally && exceptionTable[i + 3] != 1) continue;
            if (best >= 0) {
                if (bestEnd < end) continue;
                if (bestStart > start) {
                    Kit.codeBug();
                }
                if (bestEnd == end) {
                    Kit.codeBug();
                }
            }
            best = i;
            bestStart = start;
            bestEnd = end;
        }
        return best;
    }

    private static void initFunction(Context cx, Scriptable scope, InterpretedFunction parent, int index) {
        InterpretedFunction fn = InterpretedFunction.createFunction(cx, scope, parent, index);
        ScriptRuntime.initFunction(cx, scope, fn, fn.idata.itsFunctionType, parent.idata.evalScriptFlag);
    }

    static Object interpret(InterpretedFunction ifun, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (!cx.hasTopCallScope()) {
            Kit.codeBug();
        }
        CallFrame frame = Interpreter.initFrame(cx, scope, thisObj, args, null, 0, args.length, ifun, null);
        frame.isContinuationsTopFrame = cx.isContinuationsTopCall;
        cx.isContinuationsTopCall = false;
        return Interpreter.interpretLoop(cx, frame, null);
    }

    public static Object resumeGenerator(Context cx, Scriptable scope, int operation, Object savedState, Object value) {
        CallFrame frame = (CallFrame)savedState;
        GeneratorState generatorState = new GeneratorState(operation, value);
        if (operation == 2) {
            try {
                return Interpreter.interpretLoop(cx, frame, generatorState);
            }
            catch (RuntimeException e) {
                if (e != value) {
                    throw e;
                }
                return Undefined.INSTANCE;
            }
        }
        Object result = Interpreter.interpretLoop(cx, frame, generatorState);
        if (generatorState.returnedException != null) {
            throw generatorState.returnedException;
        }
        return result;
    }

    private static Object interpretLoop(Context cx, CallFrame frame, Object throwable) {
        UniqueTag DBL_MRK = UniqueTag.DOUBLE_MARK;
        Object undefined = Undefined.INSTANCE;
        boolean instructionCounting = cx.instructionThreshold != 0;
        int INVOCATION_COST = 100;
        int EXCEPTION_COST = 100;
        String stringReg = null;
        int indexReg = -1;
        if (cx.lastInterpreterFrame != null) {
            if (cx.previousInterpreterInvocations == null) {
                cx.previousInterpreterInvocations = new ObjArray();
            }
            cx.previousInterpreterInvocations.push(cx.lastInterpreterFrame);
        }
        GeneratorState generatorState = null;
        if (throwable != null) {
            if (throwable instanceof GeneratorState) {
                generatorState = (GeneratorState)throwable;
                Interpreter.enterFrame(cx, frame, ScriptRuntime.EMPTY_OBJECTS, true);
                throwable = null;
            } else {
                Kit.codeBug();
            }
        }
        Object interpreterResult = null;
        double interpreterResultDbl = 0.0;
        block124: while (true) {
            block191: {
                try {
                    block125: while (true) {
                        if (throwable != null) {
                            frame = Interpreter.processThrowable(cx, throwable, frame, indexReg, instructionCounting);
                            throwable = frame.throwable;
                            frame.throwable = null;
                        } else if (generatorState == null && frame.frozen) {
                            Kit.codeBug();
                        }
                        Object[] stack = frame.stack;
                        double[] sDbl = frame.sDbl;
                        Object[] vars = frame.varSource.stack;
                        double[] varDbls = frame.varSource.sDbl;
                        int[] varAttributes = frame.varSource.stackAttributes;
                        byte[] iCode = frame.idata.itsICode;
                        String[] strings = frame.idata.itsStringTable;
                        int stackTop = frame.savedStackTop;
                        cx.lastInterpreterFrame = frame;
                        block126: while (true) {
                            int offset;
                            int op = iCode[frame.pc++];
                            switch (op) {
                                case -62: {
                                    if (!frame.frozen) {
                                        --frame.pc;
                                        CallFrame generatorFrame = Interpreter.captureFrameForGenerator(frame);
                                        generatorFrame.frozen = true;
                                        frame.result = new ES6Generator(frame.scope, generatorFrame.fnOrScript, generatorFrame, cx);
                                        break block126;
                                    }
                                }
                                case -66: 
                                case 73: {
                                    if (!frame.frozen) {
                                        return Interpreter.freezeGenerator(cx, frame, stackTop, generatorState, op == -66);
                                    }
                                    Object obj = Interpreter.thawGenerator(cx, frame, stackTop, generatorState, op);
                                    if (obj == Scriptable.NOT_FOUND) continue block126;
                                    throwable = obj;
                                    break block191;
                                }
                                case -63: {
                                    frame.frozen = true;
                                    int sourceLine = Interpreter.getIndex(iCode, frame.pc);
                                    generatorState.returnedException = new JavaScriptException(cx, NativeIterator.getStopIterationObject(frame.scope, cx), frame.idata.itsSourceFile, sourceLine);
                                    break block126;
                                }
                                case -65: {
                                    frame.frozen = true;
                                    frame.result = stack[stackTop];
                                    frame.resultDbl = sDbl[stackTop];
                                    --stackTop;
                                    NativeIterator.StopIteration si = new NativeIterator.StopIteration(cx, frame.result == UniqueTag.DOUBLE_MARK ? Double.valueOf(frame.resultDbl) : frame.result);
                                    int sourceLine = Interpreter.getIndex(iCode, frame.pc);
                                    generatorState.returnedException = new JavaScriptException(cx, si, frame.idata.itsSourceFile, sourceLine);
                                    break block126;
                                }
                                case 50: {
                                    Object value = stack[stackTop];
                                    if (value == DBL_MRK) {
                                        value = ScriptRuntime.wrapNumber(sDbl[stackTop]);
                                    }
                                    --stackTop;
                                    int sourceLine = Interpreter.getIndex(iCode, frame.pc);
                                    throwable = new JavaScriptException(cx, value, frame.idata.itsSourceFile, sourceLine);
                                    break block191;
                                }
                                case 51: {
                                    throwable = stack[indexReg += frame.localShift];
                                    break block191;
                                }
                                case 14: 
                                case 15: 
                                case 16: 
                                case 17: {
                                    stackTop = Interpreter.doCompare(frame, op, stack, sDbl, stackTop, cx);
                                    continue block126;
                                }
                                case 52: 
                                case 53: {
                                    stackTop = Interpreter.doInOrInstanceof(cx, op, stack, sDbl, stackTop);
                                    continue block126;
                                }
                                case 12: 
                                case 13: {
                                    boolean valBln = Interpreter.doEquals(stack, sDbl, --stackTop, cx);
                                    stack[stackTop] = valBln ^= op == 13;
                                    continue block126;
                                }
                                case 46: 
                                case 47: {
                                    boolean valBln = Interpreter.doShallowEquals(stack, sDbl, --stackTop, cx);
                                    stack[stackTop] = valBln ^= op == 47;
                                    continue block126;
                                }
                                case 7: {
                                    if (!Interpreter.stack_boolean(frame, stackTop--, cx)) break;
                                    frame.pc += 2;
                                    continue block126;
                                }
                                case 6: {
                                    if (Interpreter.stack_boolean(frame, stackTop--, cx)) break;
                                    frame.pc += 2;
                                    continue block126;
                                }
                                case -6: {
                                    if (!Interpreter.stack_boolean(frame, stackTop--, cx)) {
                                        frame.pc += 2;
                                        continue block126;
                                    }
                                    stack[stackTop--] = null;
                                    break;
                                }
                                case 5: {
                                    break;
                                }
                                case -23: {
                                    stack[++stackTop] = DBL_MRK;
                                    sDbl[stackTop] = frame.pc + 2;
                                    break;
                                }
                                case -24: {
                                    if (stackTop == frame.emptyStackTop + 1) {
                                        stack[indexReg += frame.localShift] = stack[stackTop];
                                        sDbl[indexReg] = sDbl[stackTop];
                                        --stackTop;
                                        continue block126;
                                    }
                                    if (stackTop == frame.emptyStackTop) continue block126;
                                    Kit.codeBug();
                                    continue block126;
                                }
                                case -25: {
                                    Object value;
                                    if (instructionCounting) {
                                        Interpreter.addInstructionCount(cx, frame, 0);
                                    }
                                    if ((value = stack[indexReg += frame.localShift]) != DBL_MRK) {
                                        throwable = value;
                                        break block191;
                                    }
                                    frame.pc = (int)sDbl[indexReg];
                                    if (!instructionCounting) continue block126;
                                    frame.pcPrevBranch = frame.pc;
                                    continue block126;
                                }
                                case -4: {
                                    stack[stackTop] = null;
                                    --stackTop;
                                    continue block126;
                                }
                                case -5: {
                                    frame.result = stack[stackTop];
                                    frame.resultDbl = sDbl[stackTop];
                                    stack[stackTop] = null;
                                    --stackTop;
                                    continue block126;
                                }
                                case -1: {
                                    stack[stackTop + 1] = stack[stackTop];
                                    sDbl[stackTop + 1] = sDbl[stackTop];
                                    ++stackTop;
                                    continue block126;
                                }
                                case -2: {
                                    stack[stackTop + 1] = stack[stackTop - 1];
                                    sDbl[stackTop + 1] = sDbl[stackTop - 1];
                                    stack[stackTop + 2] = stack[stackTop];
                                    sDbl[stackTop + 2] = sDbl[stackTop];
                                    stackTop += 2;
                                    continue block126;
                                }
                                case -3: {
                                    Object o = stack[stackTop];
                                    stack[stackTop] = stack[stackTop - 1];
                                    stack[stackTop - 1] = o;
                                    double d = sDbl[stackTop];
                                    sDbl[stackTop] = sDbl[stackTop - 1];
                                    sDbl[stackTop - 1] = d;
                                    continue block126;
                                }
                                case 4: {
                                    frame.result = stack[stackTop];
                                    frame.resultDbl = sDbl[stackTop];
                                    --stackTop;
                                    break block126;
                                }
                                case 65: {
                                    break block126;
                                }
                                case -22: {
                                    frame.result = undefined;
                                    break block126;
                                }
                                case 27: {
                                    int rIntValue = Interpreter.stack_int32(frame, stackTop, cx);
                                    stack[stackTop] = DBL_MRK;
                                    sDbl[stackTop] = ~rIntValue;
                                    continue block126;
                                }
                                case 9: 
                                case 10: 
                                case 11: 
                                case 18: 
                                case 19: {
                                    stackTop = Interpreter.doBitOp(frame, op, stack, sDbl, stackTop, cx);
                                    continue block126;
                                }
                                case 75: {
                                    stackTop = Interpreter.doNullishCoalescing(frame, stack, sDbl, stackTop);
                                    continue block126;
                                }
                                case 20: {
                                    double lDbl = Interpreter.stack_double(frame, stackTop - 1, cx);
                                    int rIntValue = Interpreter.stack_int32(frame, stackTop, cx) & 0x1F;
                                    stack[--stackTop] = DBL_MRK;
                                    sDbl[stackTop] = ScriptRuntime.toUint32(lDbl) >>> rIntValue;
                                    continue block126;
                                }
                                case 28: 
                                case 29: {
                                    double rDbl = Interpreter.stack_double(frame, stackTop, cx);
                                    stack[stackTop] = DBL_MRK;
                                    if (op == 29) {
                                        rDbl = -rDbl;
                                    }
                                    sDbl[stackTop] = rDbl;
                                    continue block126;
                                }
                                case 21: {
                                    Interpreter.doAdd(stack, sDbl, --stackTop, cx);
                                    continue block126;
                                }
                                case 22: 
                                case 23: 
                                case 24: 
                                case 25: 
                                case 76: {
                                    stackTop = Interpreter.doArithmetic(cx, frame, op, stack, sDbl, stackTop);
                                    continue block126;
                                }
                                case 26: {
                                    stack[stackTop] = !Interpreter.stack_boolean(frame, stackTop, cx);
                                    continue block126;
                                }
                                case 49: {
                                    stack[++stackTop] = ScriptRuntime.bind(cx, frame.scope, stringReg);
                                    continue block126;
                                }
                                case 8: 
                                case 74: {
                                    Object rhs = stack[stackTop];
                                    if (rhs == DBL_MRK) {
                                        rhs = ScriptRuntime.wrapNumber(sDbl[stackTop]);
                                    }
                                    Scriptable lhs = (Scriptable)stack[--stackTop];
                                    stack[stackTop] = op == 8 ? ScriptRuntime.setName(cx, frame.scope, lhs, rhs, stringReg) : ScriptRuntime.strictSetName(cx, frame.scope, lhs, rhs, stringReg);
                                    continue block126;
                                }
                                case -59: {
                                    Object rhs = stack[stackTop];
                                    if (rhs == DBL_MRK) {
                                        rhs = ScriptRuntime.wrapNumber(sDbl[stackTop]);
                                    }
                                    Scriptable lhs = (Scriptable)stack[--stackTop];
                                    stack[stackTop] = ScriptRuntime.setConst(cx, lhs, rhs, stringReg);
                                    continue block126;
                                }
                                case 0: 
                                case 31: {
                                    stackTop = Interpreter.doDelName(cx, frame, op, stack, sDbl, stackTop);
                                    continue block126;
                                }
                                case 34: {
                                    Object lhs = stack[stackTop];
                                    if (lhs == DBL_MRK) {
                                        lhs = ScriptRuntime.wrapNumber(sDbl[stackTop]);
                                    }
                                    stack[stackTop] = ScriptRuntime.getObjectPropNoWarn(cx, frame.scope, lhs, stringReg);
                                    continue block126;
                                }
                                case 33: {
                                    Object lhs = stack[stackTop];
                                    if (lhs == DBL_MRK) {
                                        lhs = ScriptRuntime.wrapNumber(sDbl[stackTop]);
                                    }
                                    stack[stackTop] = ScriptRuntime.getObjectProp(cx, frame.scope, lhs, stringReg);
                                    continue block126;
                                }
                                case 78: {
                                    Object lhs = stack[stackTop];
                                    if (lhs == DBL_MRK) {
                                        lhs = ScriptRuntime.wrapNumber(sDbl[stackTop]);
                                    }
                                    stack[stackTop] = ScriptRuntime.getObjectPropOptional(cx, frame.scope, lhs, stringReg);
                                    continue block126;
                                }
                                case 35: {
                                    Object lhs;
                                    Object rhs = stack[stackTop];
                                    if (rhs == DBL_MRK) {
                                        rhs = ScriptRuntime.wrapNumber(sDbl[stackTop]);
                                    }
                                    if ((lhs = stack[--stackTop]) == DBL_MRK) {
                                        lhs = ScriptRuntime.wrapNumber(sDbl[stackTop]);
                                    }
                                    stack[stackTop] = ScriptRuntime.setObjectProp(cx, frame.scope, lhs, stringReg, rhs);
                                    continue block126;
                                }
                                case -9: {
                                    Object lhs = stack[stackTop];
                                    if (lhs == DBL_MRK) {
                                        lhs = ScriptRuntime.wrapNumber(sDbl[stackTop]);
                                    }
                                    stack[stackTop] = ScriptRuntime.propIncrDecr(cx, frame.scope, lhs, stringReg, iCode[frame.pc]);
                                    ++frame.pc;
                                    continue block126;
                                }
                                case 36: {
                                    stackTop = Interpreter.doGetElem(cx, frame, stack, sDbl, stackTop);
                                    continue block126;
                                }
                                case 37: {
                                    stackTop = Interpreter.doSetElem(cx, frame, stack, sDbl, stackTop);
                                    continue block126;
                                }
                                case -10: {
                                    stackTop = Interpreter.doElemIncDec(cx, frame, iCode, stack, sDbl, stackTop);
                                    continue block126;
                                }
                                case 68: {
                                    Ref ref = (Ref)stack[stackTop];
                                    stack[stackTop] = ScriptRuntime.refGet(cx, ref);
                                    continue block126;
                                }
                                case 69: {
                                    Object value = stack[stackTop];
                                    if (value == DBL_MRK) {
                                        value = ScriptRuntime.wrapNumber(sDbl[stackTop]);
                                    }
                                    Ref ref = (Ref)stack[--stackTop];
                                    stack[stackTop] = ScriptRuntime.refSet(cx, frame.scope, ref, value);
                                    continue block126;
                                }
                                case 70: {
                                    Ref ref = (Ref)stack[stackTop];
                                    stack[stackTop] = ScriptRuntime.refDel(cx, ref);
                                    continue block126;
                                }
                                case -11: {
                                    Ref ref = (Ref)stack[stackTop];
                                    stack[stackTop] = ScriptRuntime.refIncrDecr(cx, frame.scope, ref, iCode[frame.pc]);
                                    ++frame.pc;
                                    continue block126;
                                }
                                case 54: {
                                    stack[++stackTop] = stack[indexReg += frame.localShift];
                                    sDbl[stackTop] = sDbl[indexReg];
                                    continue block126;
                                }
                                case -56: {
                                    stack[indexReg += frame.localShift] = null;
                                    continue block126;
                                }
                                case -15: {
                                    stack[++stackTop] = ScriptRuntime.getNameFunctionAndThis(cx, frame.scope, stringReg);
                                    stack[++stackTop] = cx.lastStoredScriptable();
                                    continue block126;
                                }
                                case -16: {
                                    Object obj = stack[stackTop];
                                    if (obj == DBL_MRK) {
                                        obj = ScriptRuntime.wrapNumber(sDbl[stackTop]);
                                    }
                                    stack[stackTop] = ScriptRuntime.getPropFunctionAndThis(cx, frame.scope, obj, stringReg);
                                    stack[++stackTop] = cx.lastStoredScriptable();
                                    continue block126;
                                }
                                case -17: {
                                    Object id;
                                    Object obj = stack[stackTop - 1];
                                    if (obj == DBL_MRK) {
                                        obj = ScriptRuntime.wrapNumber(sDbl[stackTop - 1]);
                                    }
                                    if ((id = stack[stackTop]) == DBL_MRK) {
                                        id = ScriptRuntime.wrapNumber(sDbl[stackTop]);
                                    }
                                    stack[stackTop - 1] = ScriptRuntime.getElemFunctionAndThis(cx, frame.scope, obj, id);
                                    stack[stackTop] = cx.lastStoredScriptable();
                                    continue block126;
                                }
                                case -18: {
                                    Object value = stack[stackTop];
                                    if (value == DBL_MRK) {
                                        value = ScriptRuntime.wrapNumber(sDbl[stackTop]);
                                    }
                                    stack[stackTop] = ScriptRuntime.getValueFunctionAndThis(cx, value);
                                    stack[++stackTop] = cx.lastStoredScriptable();
                                    continue block126;
                                }
                                case -21: {
                                    if (instructionCounting) {
                                        cx.instructionCount += 100;
                                    }
                                    stackTop = Interpreter.doCallSpecial(cx, frame, stack, sDbl, stackTop, iCode, indexReg);
                                    continue block126;
                                }
                                case -55: 
                                case 38: 
                                case 71: {
                                    Callable applyCallable;
                                    IdFunctionObject ifun;
                                    if (instructionCounting) {
                                        cx.instructionCount += 100;
                                    }
                                    Callable fun = (Callable)stack[stackTop -= 1 + indexReg];
                                    Scriptable funThisObj = (Scriptable)stack[stackTop + 1];
                                    if (op == 71) {
                                        Object[] outArgs = Interpreter.getArgsArray(stack, sDbl, stackTop + 2, indexReg);
                                        stack[stackTop] = ScriptRuntime.callRef(cx, funThisObj, fun, outArgs);
                                        continue block126;
                                    }
                                    Scriptable calleeScope = frame.scope;
                                    if (frame.useActivation) {
                                        calleeScope = ScriptableObject.getTopLevelScope(frame.scope);
                                    }
                                    if (fun instanceof InterpretedFunction) {
                                        InterpretedFunction ifun2 = (InterpretedFunction)fun;
                                        CallFrame callParentFrame = frame;
                                        if (op == -55) {
                                            callParentFrame = frame.parentFrame;
                                            Interpreter.exitFrame(cx, frame, null);
                                        }
                                        CallFrame calleeFrame = Interpreter.initFrame(cx, calleeScope, funThisObj, stack, sDbl, stackTop + 2, indexReg, ifun2, callParentFrame);
                                        if (op != -55) {
                                            frame.savedStackTop = stackTop;
                                            frame.savedCallOp = op;
                                        }
                                        frame = calleeFrame;
                                        continue block125;
                                    }
                                    if (fun instanceof IdFunctionObject && BaseFunction.isApplyOrCall(ifun = (IdFunctionObject)fun) && (applyCallable = ScriptRuntime.getCallable(cx, funThisObj)) instanceof InterpretedFunction) {
                                        InterpretedFunction iApplyCallable = (InterpretedFunction)applyCallable;
                                        frame = Interpreter.initFrameForApplyOrCall(cx, frame, indexReg, stack, sDbl, stackTop, op, calleeScope, ifun, iApplyCallable);
                                        continue block125;
                                    }
                                    if (fun instanceof ScriptRuntime.NoSuchMethodShim) {
                                        ScriptRuntime.NoSuchMethodShim noSuchMethodShim = (ScriptRuntime.NoSuchMethodShim)fun;
                                        Callable noSuchMethodMethod = noSuchMethodShim.noSuchMethodMethod;
                                        if (noSuchMethodMethod instanceof InterpretedFunction) {
                                            InterpretedFunction ifun3 = (InterpretedFunction)noSuchMethodMethod;
                                            frame = Interpreter.initFrameForNoSuchMethod(cx, frame, indexReg, stack, sDbl, stackTop, op, funThisObj, calleeScope, noSuchMethodShim, ifun3);
                                            continue block125;
                                        }
                                    }
                                    cx.lastInterpreterFrame = frame;
                                    frame.savedCallOp = op;
                                    frame.savedStackTop = stackTop;
                                    stack[stackTop] = fun.call(cx, calleeScope, funThisObj, Interpreter.getArgsArray(stack, sDbl, stackTop + 2, indexReg));
                                    continue block126;
                                }
                                case 30: {
                                    Object lhs;
                                    if (instructionCounting) {
                                        cx.instructionCount += 100;
                                    }
                                    if ((lhs = stack[stackTop -= indexReg]) instanceof InterpretedFunction) {
                                        InterpretedFunction f = (InterpretedFunction)lhs;
                                        Scriptable newInstance = f.createObject(cx, frame.scope);
                                        CallFrame calleeFrame = Interpreter.initFrame(cx, frame.scope, newInstance, stack, sDbl, stackTop + 1, indexReg, f, frame);
                                        stack[stackTop] = newInstance;
                                        frame.savedStackTop = stackTop;
                                        frame.savedCallOp = op;
                                        frame = calleeFrame;
                                        continue block125;
                                    }
                                    if (!(lhs instanceof Function)) {
                                        if (lhs == DBL_MRK) {
                                            lhs = ScriptRuntime.wrapNumber(sDbl[stackTop]);
                                        }
                                        throw ScriptRuntime.notFunctionError(cx, lhs);
                                    }
                                    Function fun = (Function)lhs;
                                    Object[] outArgs = Interpreter.getArgsArray(stack, sDbl, stackTop + 1, indexReg);
                                    stack[stackTop] = fun.construct(cx, frame.scope, outArgs);
                                    continue block126;
                                }
                                case 32: {
                                    Object lhs = stack[stackTop];
                                    if (lhs == DBL_MRK) {
                                        lhs = ScriptRuntime.wrapNumber(sDbl[stackTop]);
                                    }
                                    stack[stackTop] = ScriptRuntime.typeof(cx, lhs).toString();
                                    continue block126;
                                }
                                case -14: {
                                    stack[++stackTop] = ScriptRuntime.typeofName(cx, frame.scope, stringReg).toString();
                                    continue block126;
                                }
                                case 41: {
                                    stack[++stackTop] = stringReg;
                                    continue block126;
                                }
                                case -27: {
                                    stack[++stackTop] = DBL_MRK;
                                    sDbl[stackTop] = Interpreter.getShort(iCode, frame.pc);
                                    frame.pc += 2;
                                    continue block126;
                                }
                                case -28: {
                                    stack[++stackTop] = DBL_MRK;
                                    sDbl[stackTop] = Interpreter.getInt(iCode, frame.pc);
                                    frame.pc += 4;
                                    continue block126;
                                }
                                case 40: {
                                    stack[++stackTop] = DBL_MRK;
                                    sDbl[stackTop] = frame.idata.itsDoubleTable[indexReg];
                                    continue block126;
                                }
                                case 39: {
                                    stack[++stackTop] = ScriptRuntime.name(cx, frame.scope, stringReg);
                                    continue block126;
                                }
                                case -8: {
                                    stack[++stackTop] = ScriptRuntime.nameIncrDecr(cx, frame.scope, stringReg, iCode[frame.pc]);
                                    ++frame.pc;
                                    continue block126;
                                }
                                case -61: {
                                    indexReg = iCode[frame.pc++];
                                }
                                case 157: {
                                    stackTop = Interpreter.doSetConstVar(frame, stack, sDbl, stackTop, vars, varDbls, varAttributes, indexReg, cx);
                                    continue block126;
                                }
                                case -49: {
                                    indexReg = iCode[frame.pc++];
                                }
                                case 56: {
                                    stackTop = Interpreter.doSetVar(cx, frame, stack, sDbl, stackTop, vars, varDbls, varAttributes, indexReg);
                                    continue block126;
                                }
                                case -48: {
                                    indexReg = iCode[frame.pc++];
                                }
                                case 55: {
                                    stackTop = Interpreter.doGetVar(frame, stack, sDbl, stackTop, vars, varDbls, indexReg, cx);
                                    continue block126;
                                }
                                case -7: {
                                    stackTop = Interpreter.doVarIncDec(cx, frame, stack, sDbl, stackTop, vars, varDbls, varAttributes, indexReg);
                                    continue block126;
                                }
                                case -51: {
                                    stack[++stackTop] = DBL_MRK;
                                    sDbl[stackTop] = 0.0;
                                    continue block126;
                                }
                                case -52: {
                                    stack[++stackTop] = DBL_MRK;
                                    sDbl[stackTop] = 1.0;
                                    continue block126;
                                }
                                case 42: {
                                    stack[++stackTop] = null;
                                    continue block126;
                                }
                                case 43: {
                                    stack[++stackTop] = frame.thisObj;
                                    continue block126;
                                }
                                case 64: {
                                    stack[++stackTop] = frame.fnOrScript;
                                    continue block126;
                                }
                                case 44: {
                                    stack[++stackTop] = Boolean.FALSE;
                                    continue block126;
                                }
                                case 45: {
                                    stack[++stackTop] = Boolean.TRUE;
                                    continue block126;
                                }
                                case -50: {
                                    stack[++stackTop] = undefined;
                                    continue block126;
                                }
                                case 2: {
                                    Object lhs = stack[stackTop];
                                    if (lhs == DBL_MRK) {
                                        lhs = ScriptRuntime.wrapNumber(sDbl[stackTop]);
                                    }
                                    --stackTop;
                                    frame.scope = ScriptRuntime.enterWith(cx, frame.scope, lhs);
                                    continue block126;
                                }
                                case 3: {
                                    frame.scope = ScriptRuntime.leaveWith(frame.scope);
                                    continue block126;
                                }
                                case 57: {
                                    boolean afterFirstScope = frame.idata.itsICode[frame.pc] != 0;
                                    Throwable caughtException = (Throwable)stack[--stackTop + 1];
                                    Scriptable lastCatchScope = !afterFirstScope ? null : (Scriptable)stack[indexReg += frame.localShift];
                                    stack[indexReg] = ScriptRuntime.newCatchScope(cx, frame.scope, caughtException, lastCatchScope, stringReg);
                                    ++frame.pc;
                                    continue block126;
                                }
                                case 58: 
                                case 59: 
                                case 60: 
                                case 61: {
                                    Object lhs = stack[stackTop];
                                    if (lhs == DBL_MRK) {
                                        lhs = ScriptRuntime.wrapNumber(sDbl[stackTop]);
                                    }
                                    --stackTop;
                                    int enumType = op == 58 ? 0 : (op == 59 ? 1 : (op == 61 ? 6 : 2));
                                    stack[indexReg += frame.localShift] = ScriptRuntime.enumInit(cx, frame.scope, lhs, enumType);
                                    continue block126;
                                }
                                case 62: 
                                case 63: {
                                    IdEnumeration val = (IdEnumeration)stack[indexReg += frame.localShift];
                                    stack[++stackTop] = op == 62 ? val.next(cx) : val.getId(cx);
                                    continue block126;
                                }
                                case 72: {
                                    Object obj = stack[stackTop];
                                    if (obj == DBL_MRK) {
                                        obj = ScriptRuntime.wrapNumber(sDbl[stackTop]);
                                    }
                                    stack[stackTop] = ScriptRuntime.specialRef(cx, frame.scope, obj, stringReg);
                                    continue block126;
                                }
                                case -12: {
                                    frame.scope = (Scriptable)stack[indexReg += frame.localShift];
                                    continue block126;
                                }
                                case -13: {
                                    stack[indexReg += frame.localShift] = frame.scope;
                                    continue block126;
                                }
                                case -19: {
                                    InterpretedFunction fn = InterpretedFunction.createFunction(cx, frame.scope, frame.fnOrScript, indexReg);
                                    if (fn.idata.itsFunctionType == 4) {
                                        stack[++stackTop] = new ArrowFunction(cx, frame.scope, fn, frame.thisObj);
                                        continue block126;
                                    }
                                    stack[++stackTop] = fn;
                                    continue block126;
                                }
                                case -20: {
                                    Interpreter.initFunction(cx, frame.scope, frame.fnOrScript, indexReg);
                                    continue block126;
                                }
                                case 48: {
                                    Object re = frame.idata.itsRegExpLiterals[indexReg];
                                    stack[++stackTop] = ScriptRuntime.wrapRegExp(cx, frame.scope, re);
                                    continue block126;
                                }
                                case -67: {
                                    Object[] templateLiterals = frame.idata.itsTemplateLiterals;
                                    stack[++stackTop] = ScriptRuntime.getTemplateLiteralCallSite(cx, frame.scope, templateLiterals, indexReg);
                                    continue block126;
                                }
                                case -29: {
                                    stack[++stackTop] = new int[indexReg];
                                    stack[++stackTop] = new Object[indexReg];
                                    sDbl[stackTop] = 0.0;
                                    continue block126;
                                }
                                case -30: {
                                    Object value = stack[stackTop];
                                    if (value == DBL_MRK) {
                                        value = ScriptRuntime.wrapNumber(sDbl[stackTop]);
                                    }
                                    int i = (int)sDbl[--stackTop];
                                    ((Object[])stack[stackTop])[i] = value;
                                    sDbl[stackTop] = i + 1;
                                    continue block126;
                                }
                                case -57: {
                                    Object value = stack[stackTop];
                                    int i = (int)sDbl[--stackTop];
                                    ((Object[])stack[stackTop])[i] = value;
                                    ((int[])stack[stackTop - 1])[i] = -1;
                                    sDbl[stackTop] = i + 1;
                                    continue block126;
                                }
                                case -58: {
                                    Object value = stack[stackTop];
                                    int i = (int)sDbl[--stackTop];
                                    ((Object[])stack[stackTop])[i] = value;
                                    ((int[])stack[stackTop - 1])[i] = 1;
                                    sDbl[stackTop] = i + 1;
                                    continue block126;
                                }
                                case -31: 
                                case 66: 
                                case 67: {
                                    Scriptable val;
                                    Object[] data = (Object[])stack[stackTop];
                                    int[] getterSetters = (int[])stack[--stackTop];
                                    if (op == 67) {
                                        Object[] ids = (Object[])frame.idata.literalIds[indexReg];
                                        val = ScriptRuntime.newObjectLiteral(cx, frame.scope, ids, data, getterSetters);
                                    } else {
                                        int[] skipIndexces = null;
                                        if (op == -31) {
                                            skipIndexces = (int[])frame.idata.literalIds[indexReg];
                                        }
                                        val = ScriptRuntime.newArrayLiteral(cx, frame.scope, data, skipIndexces);
                                    }
                                    stack[stackTop] = val;
                                    continue block126;
                                }
                                case -53: {
                                    Object lhs = stack[stackTop];
                                    if (lhs == DBL_MRK) {
                                        lhs = ScriptRuntime.wrapNumber(sDbl[stackTop]);
                                    }
                                    --stackTop;
                                    frame.scope = ScriptRuntime.enterDotQuery(lhs, frame.scope, cx);
                                    continue block126;
                                }
                                case -54: {
                                    boolean valBln = Interpreter.stack_boolean(frame, stackTop, cx);
                                    Object x = ScriptRuntime.updateDotQuery(valBln, frame.scope);
                                    if (x != null) {
                                        stack[stackTop] = x;
                                        frame.scope = ScriptRuntime.leaveDotQuery(frame.scope);
                                        frame.pc += 2;
                                        continue block126;
                                    }
                                    --stackTop;
                                    break;
                                }
                                case -26: {
                                    frame.pcSourceLineStart = frame.pc;
                                    frame.pc += 2;
                                    continue block126;
                                }
                                case -32: {
                                    indexReg = 0;
                                    continue block126;
                                }
                                case -33: {
                                    indexReg = 1;
                                    continue block126;
                                }
                                case -34: {
                                    indexReg = 2;
                                    continue block126;
                                }
                                case -35: {
                                    indexReg = 3;
                                    continue block126;
                                }
                                case -36: {
                                    indexReg = 4;
                                    continue block126;
                                }
                                case -37: {
                                    indexReg = 5;
                                    continue block126;
                                }
                                case -38: {
                                    indexReg = 0xFF & iCode[frame.pc];
                                    ++frame.pc;
                                    continue block126;
                                }
                                case -39: {
                                    indexReg = Interpreter.getIndex(iCode, frame.pc);
                                    frame.pc += 2;
                                    continue block126;
                                }
                                case -40: {
                                    indexReg = Interpreter.getInt(iCode, frame.pc);
                                    frame.pc += 4;
                                    continue block126;
                                }
                                case -41: {
                                    stringReg = strings[0];
                                    continue block126;
                                }
                                case -42: {
                                    stringReg = strings[1];
                                    continue block126;
                                }
                                case -43: {
                                    stringReg = strings[2];
                                    continue block126;
                                }
                                case -44: {
                                    stringReg = strings[3];
                                    continue block126;
                                }
                                case -45: {
                                    stringReg = strings[0xFF & iCode[frame.pc]];
                                    ++frame.pc;
                                    continue block126;
                                }
                                case -46: {
                                    stringReg = strings[Interpreter.getIndex(iCode, frame.pc)];
                                    frame.pc += 2;
                                    continue block126;
                                }
                                case -47: {
                                    stringReg = strings[Interpreter.getInt(iCode, frame.pc)];
                                    frame.pc += 4;
                                    continue block126;
                                }
                                default: {
                                    throw new RuntimeException("Unknown icode : " + op + " @ pc : " + (frame.pc - 1));
                                }
                            }
                            if (instructionCounting) {
                                Interpreter.addInstructionCount(cx, frame, 2);
                            }
                            frame.pc = (offset = Interpreter.getShort(iCode, frame.pc)) != 0 ? (frame.pc += offset - 1) : frame.idata.longJumps.getExistingInt(frame.pc);
                            if (!instructionCounting) continue;
                            frame.pcPrevBranch = frame.pc;
                        }
                        Interpreter.exitFrame(cx, frame, null);
                        interpreterResult = frame.result;
                        interpreterResultDbl = frame.resultDbl;
                        if (frame.parentFrame == null) break block124;
                        frame = frame.parentFrame;
                        if (frame.frozen) {
                            frame = frame.cloneFrozen();
                        }
                        Interpreter.setCallResult(frame, interpreterResult, interpreterResultDbl);
                        interpreterResult = null;
                    }
                }
                catch (Throwable ex) {
                    if (throwable != null) {
                        ex.printStackTrace(System.err);
                        throw new IllegalStateException();
                    }
                    throwable = ex;
                }
            }
            if (throwable == null) {
                Kit.codeBug();
            }
            int EX_CATCH_STATE = 2;
            boolean EX_FINALLY_STATE = true;
            boolean EX_NO_JS_STATE = false;
            int exState = generatorState != null && generatorState.operation == 2 && throwable == generatorState.value ? 1 : (throwable instanceof JavaScriptException ? 2 : (throwable instanceof EcmaError ? 2 : (throwable instanceof EvaluatorException ? 2 : (throwable instanceof RuntimeException ? 1 : (throwable instanceof Error ? 0 : 1)))));
            if (instructionCounting) {
                try {
                    Interpreter.addInstructionCount(cx, frame, 100);
                }
                catch (RuntimeException ex) {
                    throwable = ex;
                    exState = 1;
                }
                catch (Error ex) {
                    throwable = ex;
                    exState = 0;
                }
            }
            do {
                boolean onlyFinally;
                if (exState != 0 && (indexReg = Interpreter.getExceptionHandler(frame, onlyFinally = exState != 2)) >= 0) continue block124;
                Interpreter.exitFrame(cx, frame, throwable);
            } while ((frame = frame.parentFrame) != null);
            break;
        }
        if (cx.previousInterpreterInvocations != null && cx.previousInterpreterInvocations.size() != 0) {
            cx.lastInterpreterFrame = cx.previousInterpreterInvocations.pop();
        } else {
            cx.lastInterpreterFrame = null;
            cx.previousInterpreterInvocations = null;
        }
        if (throwable != null) {
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw (Error)throwable;
        }
        return interpreterResult != DBL_MRK ? interpreterResult : ScriptRuntime.wrapNumber(interpreterResultDbl);
    }

    private static int doInOrInstanceof(Context cx, int op, Object[] stack, double[] sDbl, int stackTop) {
        Object lhs;
        Object rhs = stack[stackTop];
        if (rhs == UniqueTag.DOUBLE_MARK) {
            rhs = ScriptRuntime.wrapNumber(sDbl[stackTop]);
        }
        if ((lhs = stack[--stackTop]) == UniqueTag.DOUBLE_MARK) {
            lhs = ScriptRuntime.wrapNumber(sDbl[stackTop]);
        }
        boolean valBln = op == 52 ? ScriptRuntime.in(cx, lhs, rhs) : ScriptRuntime.instanceOf(cx, lhs, rhs);
        stack[stackTop] = valBln;
        return stackTop;
    }

    private static int doCompare(CallFrame frame, int op, Object[] stack, double[] sDbl, int stackTop, Context cx) {
        boolean valBln;
        block15: {
            Object lhs;
            Object rhs;
            block14: {
                double lDbl;
                double rDbl;
                block13: {
                    block12: {
                        rhs = stack[--stackTop + 1];
                        lhs = stack[stackTop];
                        if (rhs != UniqueTag.DOUBLE_MARK) break block12;
                        rDbl = sDbl[stackTop + 1];
                        lDbl = Interpreter.stack_double(frame, stackTop, cx);
                        break block13;
                    }
                    if (lhs != UniqueTag.DOUBLE_MARK) break block14;
                    rDbl = ScriptRuntime.toNumber(cx, rhs);
                    lDbl = sDbl[stackTop];
                }
                switch (op) {
                    case 17: {
                        valBln = lDbl >= rDbl;
                        break block15;
                    }
                    case 15: {
                        valBln = lDbl <= rDbl;
                        break block15;
                    }
                    case 16: {
                        valBln = lDbl > rDbl;
                        break block15;
                    }
                    case 14: {
                        valBln = lDbl < rDbl;
                        break block15;
                    }
                    default: {
                        throw Kit.codeBug();
                    }
                }
            }
            valBln = switch (op) {
                case 17 -> ScriptRuntime.cmp_LE(cx, rhs, lhs);
                case 15 -> ScriptRuntime.cmp_LE(cx, lhs, rhs);
                case 16 -> ScriptRuntime.cmp_LT(cx, rhs, lhs);
                case 14 -> ScriptRuntime.cmp_LT(cx, lhs, rhs);
                default -> throw Kit.codeBug();
            };
        }
        stack[stackTop] = valBln;
        return stackTop;
    }

    private static int doBitOp(CallFrame frame, int op, Object[] stack, double[] sDbl, int stackTop, Context cx) {
        int lIntValue = Interpreter.stack_int32(frame, stackTop - 1, cx);
        int rIntValue = Interpreter.stack_int32(frame, stackTop, cx);
        stack[--stackTop] = UniqueTag.DOUBLE_MARK;
        sDbl[stackTop] = switch (op) {
            case 11 -> lIntValue & rIntValue;
            case 9 -> lIntValue | rIntValue;
            case 10 -> lIntValue ^ rIntValue;
            case 18 -> lIntValue << rIntValue;
            case 19 -> lIntValue >> rIntValue;
            default -> lIntValue;
        };
        return stackTop;
    }

    private static int doNullishCoalescing(CallFrame frame, Object[] stack, double[] sDbl, int stackTop) {
        Object a = frame.stack[stackTop - 1];
        Object b = frame.stack[stackTop];
        stack[--stackTop] = a == null || Undefined.isUndefined(a) ? b : a;
        return stackTop;
    }

    private static int doDelName(Context cx, CallFrame frame, int op, Object[] stack, double[] sDbl, int stackTop) {
        Object lhs;
        Object rhs = stack[stackTop];
        if (rhs == UniqueTag.DOUBLE_MARK) {
            rhs = ScriptRuntime.wrapNumber(sDbl[stackTop]);
        }
        if ((lhs = stack[--stackTop]) == UniqueTag.DOUBLE_MARK) {
            lhs = ScriptRuntime.wrapNumber(sDbl[stackTop]);
        }
        stack[stackTop] = ScriptRuntime.delete(cx, frame.scope, lhs, rhs, op == 0);
        return stackTop;
    }

    private static int doGetElem(Context cx, CallFrame frame, Object[] stack, double[] sDbl, int stackTop) {
        Object value;
        Object id;
        Object lhs;
        if ((lhs = stack[--stackTop]) == UniqueTag.DOUBLE_MARK) {
            lhs = ScriptRuntime.wrapNumber(sDbl[stackTop]);
        }
        if ((id = stack[stackTop + 1]) != UniqueTag.DOUBLE_MARK) {
            value = ScriptRuntime.getObjectElem(cx, frame.scope, lhs, id);
        } else {
            double d = sDbl[stackTop + 1];
            value = ScriptRuntime.getObjectIndex(cx, frame.scope, lhs, d);
        }
        stack[stackTop] = value;
        return stackTop;
    }

    private static int doSetElem(Context cx, CallFrame frame, Object[] stack, double[] sDbl, int stackTop) {
        Object value;
        Object id;
        Object lhs;
        Object rhs = stack[(stackTop -= 2) + 2];
        if (rhs == UniqueTag.DOUBLE_MARK) {
            rhs = ScriptRuntime.wrapNumber(sDbl[stackTop + 2]);
        }
        if ((lhs = stack[stackTop]) == UniqueTag.DOUBLE_MARK) {
            lhs = ScriptRuntime.wrapNumber(sDbl[stackTop]);
        }
        if ((id = stack[stackTop + 1]) != UniqueTag.DOUBLE_MARK) {
            value = ScriptRuntime.setObjectElem(cx, frame.scope, lhs, id, rhs);
        } else {
            double d = sDbl[stackTop + 1];
            value = ScriptRuntime.setObjectIndex(cx, frame.scope, lhs, d, rhs);
        }
        stack[stackTop] = value;
        return stackTop;
    }

    private static int doElemIncDec(Context cx, CallFrame frame, byte[] iCode, Object[] stack, double[] sDbl, int stackTop) {
        Object lhs;
        Object rhs = stack[stackTop];
        if (rhs == UniqueTag.DOUBLE_MARK) {
            rhs = ScriptRuntime.wrapNumber(sDbl[stackTop]);
        }
        if ((lhs = stack[--stackTop]) == UniqueTag.DOUBLE_MARK) {
            lhs = ScriptRuntime.wrapNumber(sDbl[stackTop]);
        }
        stack[stackTop] = ScriptRuntime.elemIncrDecr(cx, lhs, rhs, frame.scope, iCode[frame.pc]);
        ++frame.pc;
        return stackTop;
    }

    private static int doCallSpecial(Context cx, CallFrame frame, Object[] stack, double[] sDbl, int stackTop, byte[] iCode, int indexReg) {
        int callType = iCode[frame.pc] & 0xFF;
        boolean isNew = iCode[frame.pc + 1] != 0;
        int sourceLine = Interpreter.getIndex(iCode, frame.pc + 2);
        if (isNew) {
            Object function = stack[stackTop -= indexReg];
            if (function == UniqueTag.DOUBLE_MARK) {
                function = ScriptRuntime.wrapNumber(sDbl[stackTop]);
            }
            Object[] outArgs = Interpreter.getArgsArray(stack, sDbl, stackTop + 1, indexReg);
            stack[stackTop] = ScriptRuntime.newSpecial(cx, frame.scope, function, outArgs, callType);
        } else {
            Scriptable functionThis = (Scriptable)stack[(stackTop -= 1 + indexReg) + 1];
            Callable function = (Callable)stack[stackTop];
            Object[] outArgs = Interpreter.getArgsArray(stack, sDbl, stackTop + 2, indexReg);
            stack[stackTop] = ScriptRuntime.callSpecial(cx, frame.scope, function, functionThis, outArgs, frame.thisObj, callType, frame.idata.itsSourceFile, sourceLine);
        }
        frame.pc += 4;
        return stackTop;
    }

    private static int doSetConstVar(CallFrame frame, Object[] stack, double[] sDbl, int stackTop, Object[] vars, double[] varDbls, int[] varAttributes, int indexReg, Context cx) {
        if (!frame.useActivation) {
            if ((varAttributes[indexReg] & 1) == 0) {
                throw Context.reportRuntimeError1("msg.var.redecl", frame.idata.argNames[indexReg], cx);
            }
            if ((varAttributes[indexReg] & 8) != 0) {
                vars[indexReg] = stack[stackTop];
                int n = indexReg;
                varAttributes[n] = varAttributes[n] & 0xFFFFFFF7;
                varDbls[indexReg] = sDbl[stackTop];
            }
        } else {
            Object val = stack[stackTop];
            if (val == UniqueTag.DOUBLE_MARK) {
                val = ScriptRuntime.wrapNumber(sDbl[stackTop]);
            }
            String stringReg = frame.idata.argNames[indexReg];
            Scriptable scriptable = frame.scope;
            if (scriptable instanceof ConstProperties) {
                ConstProperties cp = (ConstProperties)((Object)scriptable);
                cp.putConst(cx, stringReg, frame.scope, val);
            } else {
                throw Kit.codeBug();
            }
        }
        return stackTop;
    }

    private static int doSetVar(Context cx, CallFrame frame, Object[] stack, double[] sDbl, int stackTop, Object[] vars, double[] varDbls, int[] varAttributes, int indexReg) {
        if (!frame.useActivation) {
            if ((varAttributes[indexReg] & 1) == 0) {
                vars[indexReg] = stack[stackTop];
                varDbls[indexReg] = sDbl[stackTop];
            }
        } else {
            Object val = stack[stackTop];
            if (val == UniqueTag.DOUBLE_MARK) {
                val = ScriptRuntime.wrapNumber(sDbl[stackTop]);
            }
            String stringReg = frame.idata.argNames[indexReg];
            frame.scope.put(cx, stringReg, frame.scope, val);
        }
        return stackTop;
    }

    private static int doGetVar(CallFrame frame, Object[] stack, double[] sDbl, int stackTop, Object[] vars, double[] varDbls, int indexReg, Context cx) {
        ++stackTop;
        if (!frame.useActivation) {
            stack[stackTop] = vars[indexReg];
            sDbl[stackTop] = varDbls[indexReg];
        } else {
            String stringReg = frame.idata.argNames[indexReg];
            stack[stackTop] = frame.scope.get(cx, stringReg, frame.scope);
        }
        return stackTop;
    }

    private static int doVarIncDec(Context cx, CallFrame frame, Object[] stack, double[] sDbl, int stackTop, Object[] vars, double[] varDbls, int[] varAttributes, int indexReg) {
        ++stackTop;
        byte incrDecrMask = frame.idata.itsICode[frame.pc];
        if (!frame.useActivation) {
            boolean post;
            Object varValue = vars[indexReg];
            double d = varValue == UniqueTag.DOUBLE_MARK ? varDbls[indexReg] : ScriptRuntime.toNumber(cx, varValue);
            double d2 = (incrDecrMask & 1) == 0 ? d + 1.0 : d - 1.0;
            boolean bl = post = (incrDecrMask & 2) != 0;
            if ((varAttributes[indexReg] & 1) == 0) {
                if (varValue != UniqueTag.DOUBLE_MARK) {
                    vars[indexReg] = UniqueTag.DOUBLE_MARK;
                }
                varDbls[indexReg] = d2;
                stack[stackTop] = UniqueTag.DOUBLE_MARK;
                sDbl[stackTop] = post ? d : d2;
            } else if (post && varValue != UniqueTag.DOUBLE_MARK) {
                stack[stackTop] = varValue;
            } else {
                stack[stackTop] = UniqueTag.DOUBLE_MARK;
                sDbl[stackTop] = post ? d : d2;
            }
        } else {
            String varName = frame.idata.argNames[indexReg];
            stack[stackTop] = ScriptRuntime.nameIncrDecr(cx, frame.scope, varName, incrDecrMask);
        }
        ++frame.pc;
        return stackTop;
    }

    private static CallFrame initFrameForNoSuchMethod(Context cx, CallFrame frame, int indexReg, Object[] stack, double[] sDbl, int stackTop, int op, Scriptable funThisObj, Scriptable calleeScope, ScriptRuntime.NoSuchMethodShim noSuchMethodShim, InterpretedFunction ifun) {
        Object[] argsArray = null;
        int shift = stackTop + 2;
        Object[] elements = new Object[indexReg];
        int i = 0;
        while (i < indexReg) {
            Object val = stack[shift];
            if (val == UniqueTag.DOUBLE_MARK) {
                val = ScriptRuntime.wrapNumber(sDbl[shift]);
            }
            elements[i] = val;
            ++i;
            ++shift;
        }
        argsArray = new Object[]{noSuchMethodShim.methodName, cx.newArray(calleeScope, elements)};
        CallFrame callParentFrame = frame;
        if (op == -55) {
            callParentFrame = frame.parentFrame;
            Interpreter.exitFrame(cx, frame, null);
        }
        CallFrame calleeFrame = Interpreter.initFrame(cx, calleeScope, funThisObj, argsArray, null, 0, 2, ifun, callParentFrame);
        if (op != -55) {
            frame.savedStackTop = stackTop;
            frame.savedCallOp = op;
        }
        return calleeFrame;
    }

    private static boolean doEquals(Object[] stack, double[] sDbl, int stackTop, Context cx) {
        Object rhs = stack[stackTop + 1];
        Object lhs = stack[stackTop];
        if (rhs == UniqueTag.DOUBLE_MARK) {
            if (lhs == UniqueTag.DOUBLE_MARK) {
                return sDbl[stackTop] == sDbl[stackTop + 1];
            }
            return ScriptRuntime.eqNumber(cx, sDbl[stackTop + 1], lhs);
        }
        if (lhs == UniqueTag.DOUBLE_MARK) {
            return ScriptRuntime.eqNumber(cx, sDbl[stackTop], rhs);
        }
        return ScriptRuntime.eq(cx, lhs, rhs);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean doShallowEquals(Object[] stack, double[] sDbl, int stackTop, Context cx) {
        double ldbl;
        double rdbl;
        Object rhs = stack[stackTop + 1];
        Object lhs = stack[stackTop];
        UniqueTag DBL_MRK = UniqueTag.DOUBLE_MARK;
        if (rhs == DBL_MRK) {
            rdbl = sDbl[stackTop + 1];
            if (lhs == DBL_MRK) {
                ldbl = sDbl[stackTop];
            } else {
                if (!(lhs instanceof Number)) return false;
                ldbl = ((Number)lhs).doubleValue();
            }
        } else {
            if (lhs != DBL_MRK) return ScriptRuntime.shallowEq(cx, lhs, rhs);
            ldbl = sDbl[stackTop];
            if (!(rhs instanceof Number)) return false;
            rdbl = ((Number)rhs).doubleValue();
        }
        if (ldbl != rdbl) return false;
        return true;
    }

    private static CallFrame processThrowable(Context cx, Object throwable, CallFrame frame, int indexReg, boolean instructionCounting) {
        if (indexReg >= 0) {
            if (frame.frozen) {
                frame = frame.cloneFrozen();
            }
            int[] table = frame.idata.itsExceptionTable;
            frame.pc = table[indexReg + 2];
            if (instructionCounting) {
                frame.pcPrevBranch = frame.pc;
            }
            frame.savedStackTop = frame.emptyStackTop;
            int scopeLocal = frame.localShift + table[indexReg + 5];
            int exLocal = frame.localShift + table[indexReg + 4];
            frame.scope = (Scriptable)frame.stack[scopeLocal];
            frame.stack[exLocal] = throwable;
            throwable = null;
        }
        frame.throwable = throwable;
        return frame;
    }

    private static Object freezeGenerator(Context cx, CallFrame frame, int stackTop, GeneratorState generatorState, boolean yieldStar) {
        Object result;
        if (generatorState.operation == 2) {
            throw ScriptRuntime.typeError0(cx, "msg.yield.closing");
        }
        frame.frozen = true;
        frame.result = frame.stack[stackTop];
        frame.resultDbl = frame.sDbl[stackTop];
        frame.savedStackTop = stackTop;
        --frame.pc;
        ScriptRuntime.exitActivationFunction(cx);
        Object object = result = frame.result != UniqueTag.DOUBLE_MARK ? frame.result : ScriptRuntime.wrapNumber(frame.resultDbl);
        if (yieldStar) {
            return new ES6Generator.YieldStarResult(result);
        }
        return result;
    }

    private static Object thawGenerator(Context cx, CallFrame frame, int stackTop, GeneratorState generatorState, int op) {
        frame.frozen = false;
        int sourceLine = Interpreter.getIndex(frame.idata.itsICode, frame.pc);
        frame.pc += 2;
        if (generatorState.operation == 1) {
            return new JavaScriptException(cx, generatorState.value, frame.idata.itsSourceFile, sourceLine);
        }
        if (generatorState.operation == 2) {
            return generatorState.value;
        }
        if (generatorState.operation != 0) {
            throw Kit.codeBug();
        }
        if (op == 73 || op == -66) {
            frame.stack[stackTop] = generatorState.value;
        }
        return Scriptable.NOT_FOUND;
    }

    private static CallFrame initFrameForApplyOrCall(Context cx, CallFrame frame, int indexReg, Object[] stack, double[] sDbl, int stackTop, int op, Scriptable calleeScope, IdFunctionObject ifun, InterpretedFunction iApplyCallable) {
        CallFrame calleeFrame;
        Scriptable applyThis;
        if (indexReg != 0) {
            Object obj = stack[stackTop + 2];
            if (obj == UniqueTag.DOUBLE_MARK) {
                obj = ScriptRuntime.wrapNumber(sDbl[stackTop + 2]);
            }
            applyThis = ScriptRuntime.toObjectOrNull(cx, obj, frame.scope);
        } else {
            applyThis = null;
        }
        if (applyThis == null) {
            applyThis = cx.getTopCallOrThrow();
        }
        if (op == -55) {
            Interpreter.exitFrame(cx, frame, null);
            frame = frame.parentFrame;
        } else {
            frame.savedStackTop = stackTop;
            frame.savedCallOp = op;
        }
        if (BaseFunction.isApply(ifun)) {
            Object[] callArgs = indexReg < 2 ? ScriptRuntime.EMPTY_OBJECTS : ScriptRuntime.getApplyArguments(cx, stack[stackTop + 3]);
            calleeFrame = Interpreter.initFrame(cx, calleeScope, applyThis, callArgs, null, 0, callArgs.length, iApplyCallable, frame);
        } else {
            for (int i = 1; i < indexReg; ++i) {
                stack[stackTop + 1 + i] = stack[stackTop + 2 + i];
                sDbl[stackTop + 1 + i] = sDbl[stackTop + 2 + i];
            }
            int argCount = indexReg < 2 ? 0 : indexReg - 1;
            calleeFrame = Interpreter.initFrame(cx, calleeScope, applyThis, stack, sDbl, stackTop + 2, argCount, iApplyCallable, frame);
        }
        return calleeFrame;
    }

    private static CallFrame initFrame(Context cx, Scriptable callerScope, Scriptable thisObj, Object[] args, double[] argsDbl, int argShift, int argCount, InterpretedFunction fnOrScript, CallFrame parentFrame) {
        CallFrame frame = new CallFrame(cx, thisObj, fnOrScript, parentFrame);
        frame.initializeArgs(cx, callerScope, args, argsDbl, argShift, argCount);
        Interpreter.enterFrame(cx, frame, args, false);
        return frame;
    }

    private static void enterFrame(Context cx, CallFrame frame, Object[] args, boolean continuationRestart) {
        boolean usesActivation = frame.idata.itsNeedsActivation;
        if (usesActivation) {
            Scriptable scope = frame.scope;
            if (scope == null) {
                Kit.codeBug();
            } else if (continuationRestart) {
                while (scope instanceof NativeWith) {
                    if ((scope = scope.getParentScope()) != null && (frame.parentFrame == null || frame.parentFrame.scope != scope)) continue;
                    Kit.codeBug();
                    break;
                }
            }
            if (usesActivation) {
                ScriptRuntime.enterActivationFunction(cx, scope);
            }
        }
    }

    private static void exitFrame(Context cx, CallFrame frame, Object throwable) {
        if (frame.idata.itsNeedsActivation) {
            ScriptRuntime.exitActivationFunction(cx);
        }
    }

    private static void setCallResult(CallFrame frame, Object callResult, double callResultDbl) {
        if (frame.savedCallOp == 38) {
            frame.stack[frame.savedStackTop] = callResult;
            frame.sDbl[frame.savedStackTop] = callResultDbl;
        } else if (frame.savedCallOp == 30) {
            if (callResult instanceof Scriptable) {
                frame.stack[frame.savedStackTop] = callResult;
            }
        } else {
            Kit.codeBug();
        }
        frame.savedCallOp = 0;
    }

    private static int stack_int32(CallFrame frame, int i, Context cx) {
        Object x = frame.stack[i];
        if (x == UniqueTag.DOUBLE_MARK) {
            return ScriptRuntime.toInt32(frame.sDbl[i]);
        }
        return ScriptRuntime.toInt32(cx, x);
    }

    private static double stack_double(CallFrame frame, int i, Context cx) {
        Object x = frame.stack[i];
        if (x != UniqueTag.DOUBLE_MARK) {
            return ScriptRuntime.toNumber(cx, x);
        }
        return frame.sDbl[i];
    }

    private static boolean stack_boolean(CallFrame frame, int i, Context cx) {
        Object x = Wrapper.unwrapped(frame.stack[i]);
        if (Boolean.TRUE.equals(x)) {
            return true;
        }
        if (Boolean.FALSE.equals(x)) {
            return false;
        }
        if (x == UniqueTag.DOUBLE_MARK) {
            double d = frame.sDbl[i];
            return !Double.isNaN(d) && d != 0.0;
        }
        if (x == null || x == Undefined.INSTANCE) {
            return false;
        }
        if (x instanceof Number) {
            double d = ((Number)x).doubleValue();
            return !Double.isNaN(d) && d != 0.0;
        }
        return ScriptRuntime.toBoolean(cx, x);
    }

    private static void doAdd(Object[] stack, double[] sDbl, int stackTop, Context cx) {
        boolean leftRightOrder;
        double d;
        Object rhs = stack[stackTop + 1];
        Object lhs = stack[stackTop];
        if (rhs == UniqueTag.DOUBLE_MARK) {
            d = sDbl[stackTop + 1];
            if (lhs == UniqueTag.DOUBLE_MARK) {
                int n = stackTop;
                sDbl[n] = sDbl[n] + d;
                return;
            }
            leftRightOrder = true;
        } else if (lhs == UniqueTag.DOUBLE_MARK) {
            d = sDbl[stackTop];
            lhs = rhs;
            leftRightOrder = false;
        } else {
            if (lhs instanceof Scriptable || rhs instanceof Scriptable) {
                stack[stackTop] = ScriptRuntime.add(cx, lhs, rhs);
            } else if (lhs instanceof CharSequence) {
                stack[stackTop] = rhs instanceof CharSequence ? new ConsString((CharSequence)lhs, (CharSequence)rhs) : new ConsString((CharSequence)lhs, ScriptRuntime.toCharSequence(cx, rhs));
            } else if (rhs instanceof CharSequence) {
                stack[stackTop] = new ConsString(ScriptRuntime.toCharSequence(cx, lhs), (CharSequence)rhs);
            } else {
                double lDbl = lhs instanceof Number ? ((Number)lhs).doubleValue() : ScriptRuntime.toNumber(cx, lhs);
                double rDbl = rhs instanceof Number ? ((Number)rhs).doubleValue() : ScriptRuntime.toNumber(cx, rhs);
                stack[stackTop] = UniqueTag.DOUBLE_MARK;
                sDbl[stackTop] = lDbl + rDbl;
            }
            return;
        }
        if (lhs instanceof Scriptable) {
            rhs = ScriptRuntime.wrapNumber(d);
            if (!leftRightOrder) {
                Object tmp = lhs;
                lhs = rhs;
                rhs = tmp;
            }
            stack[stackTop] = ScriptRuntime.add(cx, lhs, rhs);
        } else if (lhs instanceof CharSequence) {
            String rstr = ScriptRuntime.numberToString(cx, d, 10);
            stack[stackTop] = leftRightOrder ? new ConsString((CharSequence)lhs, rstr) : new ConsString(rstr, (CharSequence)lhs);
        } else {
            double lDbl = lhs instanceof Number ? ((Number)lhs).doubleValue() : ScriptRuntime.toNumber(cx, lhs);
            stack[stackTop] = UniqueTag.DOUBLE_MARK;
            sDbl[stackTop] = lDbl + d;
        }
    }

    private static int doArithmetic(Context cx, CallFrame frame, int op, Object[] stack, double[] sDbl, int stackTop) {
        double rDbl = Interpreter.stack_double(frame, stackTop, cx);
        double lDbl = Interpreter.stack_double(frame, --stackTop, cx);
        stack[stackTop] = UniqueTag.DOUBLE_MARK;
        sDbl[stackTop] = switch (op) {
            case 22 -> lDbl - rDbl;
            case 23 -> lDbl * rDbl;
            case 24 -> lDbl / rDbl;
            case 25 -> lDbl % rDbl;
            case 76 -> Math.pow(lDbl, rDbl);
            default -> lDbl;
        };
        return stackTop;
    }

    private static Object[] getArgsArray(Object[] stack, double[] sDbl, int shift, int count) {
        if (count == 0) {
            return ScriptRuntime.EMPTY_OBJECTS;
        }
        Object[] args = new Object[count];
        int i = 0;
        while (i != count) {
            Object val = stack[shift];
            if (val == UniqueTag.DOUBLE_MARK) {
                val = ScriptRuntime.wrapNumber(sDbl[shift]);
            }
            args[i] = val;
            ++i;
            ++shift;
        }
        return args;
    }

    private static void addInstructionCount(Context cx, CallFrame frame, int extra) {
        cx.instructionCount += frame.pc - frame.pcPrevBranch + extra;
        if (cx.instructionCount > cx.instructionThreshold) {
            cx.observeInstructionCount(cx.instructionCount);
            cx.instructionCount = 0;
        }
    }

    @Override
    public Object compile(CompilerEnvirons compilerEnv, ScriptNode tree, boolean returnFunction, Context cx) {
        CodeGenerator cgen = new CodeGenerator();
        this.itsData = cgen.compile(compilerEnv, tree, returnFunction, cx);
        return this.itsData;
    }

    @Override
    public Script createScriptObject(Object bytecode, Object staticSecurityDomain) {
        if (bytecode != this.itsData) {
            Kit.codeBug();
        }
        return InterpretedFunction.createScript(this.itsData, staticSecurityDomain);
    }

    @Override
    public void setEvalScriptFlag(Script script) {
        ((InterpretedFunction)script).idata.evalScriptFlag = true;
    }

    @Override
    public Function createFunctionObject(Context cx, Scriptable scope, Object bytecode, Object staticSecurityDomain) {
        if (bytecode != this.itsData) {
            Kit.codeBug();
        }
        return InterpretedFunction.createFunction(cx, scope, this.itsData, staticSecurityDomain);
    }

    @Override
    public void captureStackInfo(Context cx, RhinoException ex) {
        Object[] array;
        if (cx == null || cx.lastInterpreterFrame == null) {
            ex.interpreterStackInfo = null;
            ex.interpreterLineData = null;
            return;
        }
        if (cx.previousInterpreterInvocations == null || cx.previousInterpreterInvocations.size() == 0) {
            array = new CallFrame[1];
        } else {
            int previousCount = cx.previousInterpreterInvocations.size();
            if (cx.previousInterpreterInvocations.peek() == cx.lastInterpreterFrame) {
                --previousCount;
            }
            array = new CallFrame[previousCount + 1];
            cx.previousInterpreterInvocations.toArray(array);
        }
        array[array.length - 1] = (CallFrame)cx.lastInterpreterFrame;
        int interpreterFrameCount = 0;
        for (int i = 0; i != array.length; ++i) {
            interpreterFrameCount += 1 + ((CallFrame)array[i]).frameIndex;
        }
        int[] linePC = new int[interpreterFrameCount];
        int linePCIndex = interpreterFrameCount;
        int i = array.length;
        while (i != 0) {
            Object frame = array[--i];
            while (frame != null) {
                linePC[--linePCIndex] = ((CallFrame)frame).pcSourceLineStart;
                frame = ((CallFrame)frame).parentFrame;
            }
        }
        if (linePCIndex != 0) {
            Kit.codeBug();
        }
        ex.interpreterStackInfo = array;
        ex.interpreterLineData = linePC;
    }

    @Override
    public String getSourcePositionFromStack(Context cx, int[] linep) {
        CallFrame frame = (CallFrame)cx.lastInterpreterFrame;
        InterpreterData idata = frame.idata;
        linep[0] = frame.pcSourceLineStart >= 0 ? Interpreter.getIndex(idata.itsICode, frame.pcSourceLineStart) : 0;
        return idata.itsSourceFile;
    }

    @Override
    public String getPatchedStack(RhinoException ex, String nativeStackTrace) {
        String tag = "dev.latvian.mods.rhino.Interpreter.interpretLoop";
        StringBuilder sb = new StringBuilder(nativeStackTrace.length() + 1000);
        String lineSeparator = System.lineSeparator();
        CallFrame[] array = (CallFrame[])ex.interpreterStackInfo;
        int[] linePC = ex.interpreterLineData;
        int arrayIndex = array.length;
        int linePCIndex = linePC.length;
        int offset = 0;
        while (arrayIndex != 0) {
            char c;
            --arrayIndex;
            int pos = nativeStackTrace.indexOf(tag, offset);
            if (pos < 0) break;
            pos += tag.length();
            while (pos != nativeStackTrace.length() && (c = nativeStackTrace.charAt(pos)) != '\n' && c != '\r') {
                ++pos;
            }
            sb.append(nativeStackTrace, offset, pos);
            offset = pos;
            CallFrame frame = array[arrayIndex];
            while (frame != null) {
                if (linePCIndex == 0) {
                    Kit.codeBug();
                }
                --linePCIndex;
                InterpreterData idata = frame.idata;
                sb.append(lineSeparator);
                sb.append("\tat script");
                if (idata.itsName != null && idata.itsName.length() != 0) {
                    sb.append('.');
                    sb.append(idata.itsName);
                }
                sb.append('(');
                sb.append(idata.itsSourceFile);
                int pc = linePC[linePCIndex];
                if (pc >= 0) {
                    sb.append(':');
                    sb.append(Interpreter.getIndex(idata.itsICode, pc));
                }
                sb.append(')');
                frame = frame.parentFrame;
            }
        }
        sb.append(nativeStackTrace.substring(offset));
        return sb.toString();
    }

    @Override
    public List<String> getScriptStack(RhinoException ex) {
        ScriptStackElement[][] stack = this.getScriptStackElements(ex);
        ArrayList<String> list = new ArrayList<String>(stack.length);
        String lineSeparator = System.lineSeparator();
        for (ScriptStackElement[] group : stack) {
            StringBuilder sb = new StringBuilder();
            for (ScriptStackElement elem : group) {
                elem.renderJavaStyle(sb);
                sb.append(lineSeparator);
            }
            list.add(sb.toString());
        }
        return list;
    }

    public ScriptStackElement[][] getScriptStackElements(RhinoException ex) {
        if (ex.interpreterStackInfo == null) {
            return null;
        }
        ArrayList<ScriptStackElement[]> list = new ArrayList<ScriptStackElement[]>();
        CallFrame[] array = (CallFrame[])ex.interpreterStackInfo;
        int[] linePC = ex.interpreterLineData;
        int arrayIndex = array.length;
        int linePCIndex = linePC.length;
        while (arrayIndex != 0) {
            CallFrame frame = array[--arrayIndex];
            ArrayList<ScriptStackElement> group = new ArrayList<ScriptStackElement>();
            while (frame != null) {
                int pc;
                if (linePCIndex == 0) {
                    Kit.codeBug();
                }
                InterpreterData idata = frame.idata;
                String fileName = idata.itsSourceFile;
                String functionName = null;
                int lineNumber = -1;
                if ((pc = linePC[--linePCIndex]) >= 0) {
                    lineNumber = Interpreter.getIndex(idata.itsICode, pc);
                }
                if (idata.itsName != null && idata.itsName.length() != 0) {
                    functionName = idata.itsName;
                }
                frame = frame.parentFrame;
                group.add(new ScriptStackElement(fileName, functionName, lineNumber));
            }
            list.add(group.toArray(new ScriptStackElement[0]));
        }
        return (ScriptStackElement[][])list.toArray((T[])new ScriptStackElement[list.size()][]);
    }

    private static class CallFrame
    implements Cloneable {
        final Context localContext;
        final InterpretedFunction fnOrScript;
        final InterpreterData idata;
        final CallFrame varSource;
        final int localShift;
        final int emptyStackTop;
        final boolean useActivation;
        final Scriptable thisObj;
        CallFrame parentFrame;
        int frameIndex;
        boolean frozen;
        Object[] stack;
        int[] stackAttributes;
        double[] sDbl;
        boolean isContinuationsTopFrame;
        Object result;
        double resultDbl;
        int pc;
        int pcPrevBranch;
        int pcSourceLineStart;
        Scriptable scope;
        int savedStackTop;
        int savedCallOp;
        Object throwable;

        private static Boolean equals(CallFrame f1, CallFrame f2, EqualObjectGraphs equal, Context cx) {
            while (f1 != f2) {
                if (f1 == null || f2 == null) {
                    return Boolean.FALSE;
                }
                if (!f1.fieldsEqual(f2, equal, cx)) {
                    return Boolean.FALSE;
                }
                f1 = f1.parentFrame;
                f2 = f2.parentFrame;
            }
            return Boolean.TRUE;
        }

        CallFrame(Context cx, Scriptable thisObj, InterpretedFunction fnOrScript, CallFrame parentFrame) {
            this.localContext = cx;
            this.idata = fnOrScript.idata;
            this.useActivation = this.idata.itsNeedsActivation;
            this.emptyStackTop = this.idata.itsMaxVars + this.idata.itsMaxLocals - 1;
            this.fnOrScript = fnOrScript;
            this.varSource = this;
            this.localShift = this.idata.itsMaxVars;
            this.thisObj = thisObj;
            this.parentFrame = parentFrame;
            int n = this.frameIndex = parentFrame == null ? 0 : parentFrame.frameIndex + 1;
            if (this.frameIndex > cx.getMaximumInterpreterStackDepth()) {
                throw Context.reportRuntimeError("Exceeded maximum stack depth", cx);
            }
            this.result = Undefined.INSTANCE;
            this.pcSourceLineStart = this.idata.firstLinePC;
            this.savedStackTop = this.emptyStackTop;
        }

        void initializeArgs(Context cx, Scriptable callerScope, Object[] args, double[] argsDbl, int argShift, int argCount) {
            int maxFrameArray;
            if (this.useActivation) {
                if (argsDbl != null) {
                    args = Interpreter.getArgsArray(args, argsDbl, argShift, argCount);
                }
                argShift = 0;
                argsDbl = null;
            }
            if (this.idata.itsFunctionType != 0) {
                this.scope = this.fnOrScript.getParentScope();
                if (this.useActivation) {
                    this.scope = this.idata.itsFunctionType == 4 ? ScriptRuntime.createArrowFunctionActivation(cx, this.scope, this.fnOrScript, args, this.idata.isStrict) : ScriptRuntime.createFunctionActivation(cx, this.scope, this.fnOrScript, args, this.idata.isStrict);
                }
            } else {
                this.scope = callerScope;
                ScriptRuntime.initScript(cx, this.scope, this.fnOrScript, this.thisObj, this.fnOrScript.idata.evalScriptFlag);
            }
            if (this.idata.itsNestedFunctions != null) {
                if (this.idata.itsFunctionType != 0 && !this.idata.itsNeedsActivation) {
                    Kit.codeBug();
                }
                for (int i = 0; i < this.idata.itsNestedFunctions.length; ++i) {
                    InterpreterData fdata = this.idata.itsNestedFunctions[i];
                    if (fdata.itsFunctionType != 1) continue;
                    Interpreter.initFunction(cx, this.scope, this.fnOrScript, i);
                }
            }
            if ((maxFrameArray = this.idata.itsMaxFrameArray) != this.emptyStackTop + this.idata.itsMaxStack + 1) {
                Kit.codeBug();
            }
            this.stack = new Object[maxFrameArray];
            this.stackAttributes = new int[maxFrameArray];
            this.sDbl = new double[maxFrameArray];
            int varCount = this.idata.getParamAndVarCount();
            for (int i = 0; i < varCount; ++i) {
                if (!this.idata.getParamOrVarConst(i)) continue;
                this.stackAttributes[i] = 13;
            }
            int definedArgs = this.idata.argCount;
            if (definedArgs > argCount) {
                definedArgs = argCount;
            }
            System.arraycopy(args, argShift, this.stack, 0, definedArgs);
            if (argsDbl != null) {
                System.arraycopy(argsDbl, argShift, this.sDbl, 0, definedArgs);
            }
            for (int i = definedArgs; i != this.idata.itsMaxVars; ++i) {
                this.stack[i] = Undefined.INSTANCE;
            }
        }

        CallFrame cloneFrozen() {
            CallFrame copy;
            if (!this.frozen) {
                Kit.codeBug();
            }
            try {
                copy = (CallFrame)this.clone();
            }
            catch (CloneNotSupportedException ex) {
                throw new IllegalStateException();
            }
            copy.stack = (Object[])this.stack.clone();
            copy.stackAttributes = (int[])this.stackAttributes.clone();
            copy.sDbl = (double[])this.sDbl.clone();
            copy.frozen = false;
            return copy;
        }

        public boolean equals(Object other) {
            if (other instanceof CallFrame) {
                CallFrame otherCallFrame = (CallFrame)other;
                Context cx = this.localContext.factory.enter();
                if (cx.hasTopCallScope()) {
                    return this.equalsInTopScope(otherCallFrame);
                }
                Scriptable top = ScriptableObject.getTopLevelScope(this.scope);
                return (Boolean)cx.doTopCall(top, (c, scope, thisObj, args) -> this.equalsInTopScope(otherCallFrame), top, ScriptRuntime.EMPTY_OBJECTS, this.isStrictTopFrame());
            }
            return false;
        }

        public int hashCode() {
            int depth = 0;
            CallFrame f = this;
            int h = 0;
            do {
                h = 31 * (31 * h + f.pc) + f.idata.icodeHashCode();
            } while ((f = f.parentFrame) != null && depth++ < 8);
            return h;
        }

        private Boolean equalsInTopScope(CallFrame other) {
            return EqualObjectGraphs.withThreadLocal(eq -> CallFrame.equals(this, other, eq, this.localContext.factory.enter()));
        }

        private boolean isStrictTopFrame() {
            CallFrame f = this;
            CallFrame p;
            while ((p = f.parentFrame) != null) {
                f = p;
            }
            return f.idata.isStrict;
        }

        private boolean fieldsEqual(CallFrame other, EqualObjectGraphs equal, Context cx) {
            return this.frameIndex == other.frameIndex && this.pc == other.pc && Interpreter.compareIdata(this.idata, other.idata) && equal.equalGraphs(cx, this.varSource.stack, other.varSource.stack) && Arrays.equals(this.varSource.sDbl, other.varSource.sDbl) && equal.equalGraphs(cx, this.thisObj, other.thisObj) && equal.equalGraphs(cx, this.fnOrScript, other.fnOrScript) && equal.equalGraphs(cx, this.scope, other.scope);
        }
    }
}

