/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino;

import dev.latvian.mods.rhino.BaseFunction;
import dev.latvian.mods.rhino.Callable;
import dev.latvian.mods.rhino.ConstProperties;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.ExternalArrayData;
import dev.latvian.mods.rhino.Function;
import dev.latvian.mods.rhino.FunctionObject;
import dev.latvian.mods.rhino.JavaScriptException;
import dev.latvian.mods.rhino.Kit;
import dev.latvian.mods.rhino.MemberBox;
import dev.latvian.mods.rhino.MemberType;
import dev.latvian.mods.rhino.NativeObject;
import dev.latvian.mods.rhino.ObjToIntMap;
import dev.latvian.mods.rhino.ScriptRuntime;
import dev.latvian.mods.rhino.Scriptable;
import dev.latvian.mods.rhino.SlotMapContainer;
import dev.latvian.mods.rhino.Symbol;
import dev.latvian.mods.rhino.SymbolScriptable;
import dev.latvian.mods.rhino.TopLevel;
import dev.latvian.mods.rhino.Undefined;
import dev.latvian.mods.rhino.WrappedExecutable;
import dev.latvian.mods.rhino.Wrapper;
import dev.latvian.mods.rhino.annotations.JSConstructor;
import dev.latvian.mods.rhino.annotations.JSFunction;
import dev.latvian.mods.rhino.annotations.JSGetter;
import dev.latvian.mods.rhino.annotations.JSSetter;
import dev.latvian.mods.rhino.annotations.JSStaticFunction;
import dev.latvian.mods.rhino.util.DefaultValueTypeHint;
import dev.latvian.mods.rhino.util.Deletable;
import dev.latvian.mods.rhino.util.WrappedReflectionMethod;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public abstract class ScriptableObject
implements Scriptable,
SymbolScriptable,
ConstProperties {
    public static final int EMPTY = 0;
    public static final int READONLY = 1;
    public static final int DONTENUM = 2;
    public static final int PERMANENT = 4;
    public static final int UNINITIALIZED_CONST = 8;
    public static final int CONST = 13;
    private static final WrappedExecutable GET_ARRAY_LENGTH = (cx, scope, self, args) -> ((ScriptableObject)self).getExternalArrayLength();
    private static final Comparator<Object> KEY_COMPARATOR = new KeyComparator();
    private final transient SlotMapContainer slotMap;
    private Scriptable prototypeObject;
    private Scriptable parentScopeObject;
    private transient ExternalArrayData externalData;
    private volatile Map<Object, Object> associatedValues;
    private boolean isExtensible = true;
    private boolean isSealed = false;

    protected static ScriptableObject buildDataDescriptor(Scriptable scope, Object value, int attributes, Context cx) {
        NativeObject desc = new NativeObject(cx.factory);
        ScriptRuntime.setBuiltinProtoAndParent(cx, scope, desc, TopLevel.Builtins.Object);
        desc.defineProperty(cx, "value", value, 0);
        desc.defineProperty(cx, "writable", (Object)((attributes & 1) == 0 ? 1 : 0), 0);
        desc.defineProperty(cx, "enumerable", (Object)((attributes & 2) == 0 ? 1 : 0), 0);
        desc.defineProperty(cx, "configurable", (Object)((attributes & 4) == 0 ? 1 : 0), 0);
        return desc;
    }

    static void checkValidAttributes(int attributes) {
        int mask = 15;
        if ((attributes & 0xFFFFFFF0) != 0) {
            throw new IllegalArgumentException(String.valueOf(attributes));
        }
    }

    private static SlotMapContainer createSlotMap(int initialSize) {
        return new SlotMapContainer(initialSize);
    }

    public static Object getDefaultValue(Scriptable object, DefaultValueTypeHint typeHint, Context cx) {
        for (int i = 0; i < 2; ++i) {
            Object u;
            Function fun;
            boolean tryToString = typeHint == DefaultValueTypeHint.STRING ? i == 0 : i == 1;
            String methodName = tryToString ? "toString" : "valueOf";
            Object v = ScriptableObject.getProperty(object, methodName, cx);
            if (!(v instanceof Function) || (v = (fun = (Function)v).call(cx, fun.getParentScope(), object, ScriptRuntime.EMPTY_OBJECTS)) == null) continue;
            if (!(v instanceof Scriptable)) {
                return v;
            }
            if (typeHint == DefaultValueTypeHint.CLASS || typeHint == DefaultValueTypeHint.FUNCTION) {
                return v;
            }
            if (!tryToString || !(v instanceof Wrapper) || !((u = ((Wrapper)v).unwrap()) instanceof String)) continue;
            return u;
        }
        throw ScriptRuntime.typeError1(cx, "msg.default.value", typeHint == null ? "undefined" : typeHint.name);
    }

    public static <T extends Scriptable> void defineClass(Scriptable scope, Class<T> clazz, Context cx) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        ScriptableObject.defineClass(scope, clazz, false, false, cx);
    }

    public static <T extends Scriptable> void defineClass(Scriptable scope, Class<T> clazz, boolean sealed, Context cx) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        ScriptableObject.defineClass(scope, clazz, sealed, false, cx);
    }

    public static <T extends Scriptable> String defineClass(Scriptable scope, Class<T> clazz, boolean sealed, boolean mapInheritance, Context cx) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        BaseFunction ctor = ScriptableObject.buildClassCtor(scope, clazz, sealed, mapInheritance, cx);
        if (ctor == null) {
            return null;
        }
        String name = ctor.getClassPrototype(cx).getClassName();
        ScriptableObject.defineProperty(scope, name, ctor, 2, cx);
        return name;
    }

    static <T extends Scriptable> BaseFunction buildClassCtor(Scriptable scope, Class<T> clazz, boolean sealed, boolean mapInheritance, Context cx) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        FunctionObject ctor;
        Class<T> superScriptable;
        String name;
        Class<T> superClass;
        Object existingProto;
        AccessibleObject[] methods;
        for (Method method : methods = FunctionObject.getMethodList(clazz)) {
            if (!method.getName().equals("init")) continue;
            Class<?>[] parmTypes = method.getParameterTypes();
            if (parmTypes.length == 3 && parmTypes[0] == ScriptRuntime.ContextClass && parmTypes[1] == ScriptRuntime.ScriptableClass && parmTypes[2] == Boolean.TYPE && Modifier.isStatic(method.getModifiers())) {
                Object[] args = new Object[]{cx, scope, sealed ? Boolean.TRUE : Boolean.FALSE};
                method.invoke(null, args);
                return null;
            }
            if (parmTypes.length != 1 || parmTypes[0] != ScriptRuntime.ScriptableClass || !Modifier.isStatic(method.getModifiers())) continue;
            Object[] args = new Object[]{scope};
            method.invoke(null, args);
            return null;
        }
        AccessibleObject[] ctors = clazz.getConstructors();
        Constructor<?> protoCtor = null;
        for (int i = 0; i < ctors.length; ++i) {
            if (ctors[i].getParameterTypes().length != 0) continue;
            protoCtor = ctors[i];
            break;
        }
        if (protoCtor == null) {
            throw Context.reportRuntimeError1("msg.zero.arg.ctor", clazz.getName(), cx);
        }
        Scriptable proto = (Scriptable)protoCtor.newInstance(ScriptRuntime.EMPTY_OBJECTS);
        String string = proto.getClassName();
        Object existing = ScriptableObject.getProperty(ScriptableObject.getTopLevelScope(scope), string, cx);
        if (existing instanceof BaseFunction && (existingProto = ((BaseFunction)existing).getPrototypeProperty(cx)) != null && clazz.equals(existingProto.getClass())) {
            return (BaseFunction)existing;
        }
        Scriptable superProto = null;
        if (mapInheritance && ScriptRuntime.ScriptableClass.isAssignableFrom(superClass = clazz.getSuperclass()) && !Modifier.isAbstract(superClass.getModifiers()) && (name = ScriptableObject.defineClass(scope, superScriptable = ScriptableObject.extendsScriptable(superClass), sealed, mapInheritance, cx)) != null) {
            superProto = ScriptableObject.getClassPrototype(scope, name, cx);
        }
        if (superProto == null) {
            superProto = ScriptableObject.getObjectPrototype(scope, cx);
        }
        proto.setPrototype(superProto);
        String functionPrefix = "jsFunction_";
        String staticFunctionPrefix = "jsStaticFunction_";
        String getterPrefix = "jsGet_";
        String setterPrefix = "jsSet_";
        String ctorName = "jsConstructor";
        Object ctorMember = ScriptableObject.findAnnotatedMember(methods, JSConstructor.class);
        if (ctorMember == null) {
            ctorMember = ScriptableObject.findAnnotatedMember(ctors, JSConstructor.class);
        }
        if (ctorMember == null) {
            ctorMember = FunctionObject.findSingleMethod((Method[])methods, "jsConstructor", cx);
        }
        if (ctorMember == null) {
            if (ctors.length == 1) {
                ctorMember = ctors[0];
            } else if (ctors.length == 2) {
                if (((Constructor)ctors[0]).getParameterTypes().length == 0) {
                    ctorMember = ctors[1];
                } else if (((Constructor)ctors[1]).getParameterTypes().length == 0) {
                    ctorMember = ctors[0];
                }
            }
            if (ctorMember == null) {
                throw Context.reportRuntimeError1("msg.ctor.multiple.parms", clazz.getName(), cx);
            }
        }
        if ((ctor = new FunctionObject(string, (Member)ctorMember, scope, cx)).isVarArgsMethod()) {
            throw Context.reportRuntimeError1("msg.varargs.ctor", ctorMember.getName(), cx);
        }
        ctor.initAsConstructor(scope, proto, cx);
        AccessibleObject finishInit = null;
        HashSet<String> staticNames = new HashSet<String>();
        HashSet instanceNames = new HashSet();
        for (AccessibleObject method : methods) {
            String propName;
            boolean isStatic;
            HashSet<String> names;
            Class<?>[] parmTypes;
            if (method == ctorMember) continue;
            String name2 = ((Method)method).getName();
            if (name2.equals("finishInit") && (parmTypes = ((Method)method).getParameterTypes()).length == 3 && parmTypes[0] == ScriptRuntime.ScriptableClass && parmTypes[1] == FunctionObject.class && parmTypes[2] == ScriptRuntime.ScriptableClass && Modifier.isStatic(((Method)method).getModifiers())) {
                finishInit = method;
                continue;
            }
            if (name2.indexOf(36) != -1 || name2.equals("jsConstructor")) continue;
            Annotation annotation = null;
            String prefix = null;
            if (method.isAnnotationPresent(JSFunction.class)) {
                annotation = ((Method)method).getAnnotation(JSFunction.class);
            } else if (method.isAnnotationPresent(JSStaticFunction.class)) {
                annotation = ((Method)method).getAnnotation(JSStaticFunction.class);
            } else if (method.isAnnotationPresent(JSGetter.class)) {
                annotation = ((Method)method).getAnnotation(JSGetter.class);
            } else if (method.isAnnotationPresent(JSSetter.class)) continue;
            if (annotation == null) {
                if (name2.startsWith("jsFunction_")) {
                    prefix = "jsFunction_";
                } else if (name2.startsWith("jsStaticFunction_")) {
                    prefix = "jsStaticFunction_";
                } else {
                    if (!name2.startsWith("jsGet_")) continue;
                    prefix = "jsGet_";
                }
            }
            if ((names = (isStatic = annotation instanceof JSStaticFunction || prefix == "jsStaticFunction_") ? staticNames : instanceNames).contains(propName = ScriptableObject.getPropertyName(name2, prefix, annotation))) {
                throw Context.reportRuntimeError2("duplicate.defineClass.name", name2, propName, cx);
            }
            names.add(propName);
            name2 = propName;
            if (annotation instanceof JSGetter || prefix == "jsGet_") {
                if (!(proto instanceof ScriptableObject)) {
                    throw Context.reportRuntimeError2("msg.extend.scriptable", proto.getClass().toString(), name2, cx);
                }
                Method setter = ScriptableObject.findSetterMethod((Method[])methods, name2, "jsSet_");
                int attr = 6 | (setter != null ? 0 : 1);
                ((ScriptableObject)proto).defineProperty(cx, name2, null, WrappedReflectionMethod.of((Method)method), WrappedReflectionMethod.of(setter), attr);
                continue;
            }
            if (isStatic && !Modifier.isStatic(((Method)method).getModifiers())) {
                throw Context.reportRuntimeError("jsStaticFunction must be used with static method.", cx);
            }
            FunctionObject f = new FunctionObject(name2, (Member)((Object)method), proto, cx);
            if (f.isVarArgsConstructor()) {
                throw Context.reportRuntimeError1("msg.varargs.fun", ctorMember.getName(), cx);
            }
            ScriptableObject.defineProperty(isStatic ? ctor : proto, name2, f, 2, cx);
            if (!sealed) continue;
            f.sealObject(cx);
        }
        if (finishInit != null) {
            Object[] finishArgs = new Object[]{scope, ctor, proto};
            finishInit.invoke(null, finishArgs);
        }
        if (sealed) {
            ctor.sealObject(cx);
            if (proto instanceof ScriptableObject) {
                ((ScriptableObject)proto).sealObject(cx);
            }
        }
        return ctor;
    }

    private static Member findAnnotatedMember(AccessibleObject[] members, Class<? extends Annotation> annotation) {
        for (AccessibleObject member : members) {
            if (!member.isAnnotationPresent(annotation)) continue;
            return (Member)((Object)member);
        }
        return null;
    }

    private static Method findSetterMethod(Method[] methods, String name, String prefix) {
        String newStyleName = "set" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
        for (Method method : methods) {
            JSSetter annotation = method.getAnnotation(JSSetter.class);
            if (annotation == null || !name.equals(annotation.value()) && (!"".equals(annotation.value()) || !newStyleName.equals(method.getName()))) continue;
            return method;
        }
        String oldStyleName = prefix + name;
        for (Method method : methods) {
            if (!oldStyleName.equals(method.getName())) continue;
            return method;
        }
        return null;
    }

    private static String getPropertyName(String methodName, String prefix, Annotation annotation) {
        if (prefix != null) {
            return methodName.substring(prefix.length());
        }
        Object propName = null;
        if (annotation instanceof JSGetter) {
            propName = ((JSGetter)annotation).value();
            if ((propName == null || ((String)propName).length() == 0) && methodName.length() > 3 && methodName.startsWith("get") && Character.isUpperCase(((String)(propName = methodName.substring(3))).charAt(0))) {
                if (((String)propName).length() == 1) {
                    propName = ((String)propName).toLowerCase();
                } else if (!Character.isUpperCase(((String)propName).charAt(1))) {
                    propName = Character.toLowerCase(((String)propName).charAt(0)) + ((String)propName).substring(1);
                }
            }
        } else if (annotation instanceof JSFunction) {
            propName = ((JSFunction)annotation).value();
        } else if (annotation instanceof JSStaticFunction) {
            propName = ((JSStaticFunction)annotation).value();
        }
        if (propName == null || ((String)propName).length() == 0) {
            propName = methodName;
        }
        return propName;
    }

    private static <T extends Scriptable> Class<T> extendsScriptable(Class<?> c) {
        if (ScriptRuntime.ScriptableClass.isAssignableFrom(c)) {
            return c;
        }
        return null;
    }

    public static void defineProperty(Scriptable destination, String propertyName, Object value, int attributes, Context cx) {
        if (!(destination instanceof ScriptableObject)) {
            destination.put(cx, propertyName, destination, value);
            return;
        }
        ScriptableObject so = (ScriptableObject)destination;
        so.defineProperty(cx, propertyName, value, attributes);
    }

    public static void defineConstProperty(Scriptable destination, String propertyName, Context cx) {
        if (destination instanceof ConstProperties) {
            ConstProperties cp = (ConstProperties)((Object)destination);
            cp.defineConst(cx, propertyName, destination);
        } else {
            ScriptableObject.defineProperty(destination, propertyName, Undefined.INSTANCE, 13, cx);
        }
    }

    protected static boolean isTrue(Object value, Context cx) {
        return value != NOT_FOUND && ScriptRuntime.toBoolean(cx, value);
    }

    protected static boolean isFalse(Object value, Context cx) {
        return !ScriptableObject.isTrue(value, cx);
    }

    protected static Scriptable ensureScriptable(Object arg, Context cx) {
        if (!(arg instanceof Scriptable)) {
            throw ScriptRuntime.typeError1(cx, "msg.arg.not.object", (Object)ScriptRuntime.typeof(cx, arg));
        }
        return (Scriptable)arg;
    }

    protected static SymbolScriptable ensureSymbolScriptable(Object arg, Context cx) {
        if (!(arg instanceof SymbolScriptable)) {
            throw ScriptRuntime.typeError1(cx, "msg.object.not.symbolscriptable", (Object)ScriptRuntime.typeof(cx, arg));
        }
        return (SymbolScriptable)arg;
    }

    protected static ScriptableObject ensureScriptableObject(Object arg, Context cx) {
        if (!(arg instanceof ScriptableObject)) {
            throw ScriptRuntime.typeError1(cx, "msg.arg.not.object", (Object)ScriptRuntime.typeof(cx, arg));
        }
        return (ScriptableObject)arg;
    }

    public static Scriptable getObjectPrototype(Scriptable scope, Context cx) {
        return TopLevel.getBuiltinPrototype(ScriptableObject.getTopLevelScope(scope), TopLevel.Builtins.Object, cx);
    }

    public static Scriptable getFunctionPrototype(Scriptable scope, Context cx) {
        return TopLevel.getBuiltinPrototype(ScriptableObject.getTopLevelScope(scope), TopLevel.Builtins.Function, cx);
    }

    public static Scriptable getGeneratorFunctionPrototype(Scriptable scope, Context cx) {
        return TopLevel.getBuiltinPrototype(ScriptableObject.getTopLevelScope(scope), TopLevel.Builtins.GeneratorFunction, cx);
    }

    public static Scriptable getArrayPrototype(Scriptable scope, Context cx) {
        return TopLevel.getBuiltinPrototype(ScriptableObject.getTopLevelScope(scope), TopLevel.Builtins.Array, cx);
    }

    public static Scriptable getClassPrototype(Scriptable scope, String className, Context cx) {
        Object proto;
        Object ctor = ScriptableObject.getProperty(scope = ScriptableObject.getTopLevelScope(scope), className, cx);
        if (ctor instanceof BaseFunction) {
            proto = ((BaseFunction)ctor).getPrototypeProperty(cx);
        } else if (ctor instanceof Scriptable) {
            Scriptable ctorObj = (Scriptable)ctor;
            proto = ctorObj.get(cx, "prototype", ctorObj);
        } else {
            return null;
        }
        if (proto instanceof Scriptable) {
            return (Scriptable)proto;
        }
        return null;
    }

    public static Scriptable getTopLevelScope(Scriptable obj) {
        Scriptable parent;
        while ((parent = obj.getParentScope()) != null) {
            obj = parent;
        }
        return obj;
    }

    public static Object getProperty(Scriptable obj, String name, Context cx) {
        Object result;
        Scriptable start = obj;
        while ((result = obj.get(cx, name, start)) == NOT_FOUND && (obj = obj.getPrototype(cx)) != null) {
        }
        return result;
    }

    public static Object getProperty(Scriptable obj, Symbol key, Context cx) {
        Object result;
        Scriptable start = obj;
        while ((result = ScriptableObject.ensureSymbolScriptable(obj, cx).get(cx, key, start)) == NOT_FOUND && (obj = obj.getPrototype(cx)) != null) {
        }
        return result;
    }

    public static Object getProperty(Scriptable obj, int index, Context cx) {
        Object result;
        Scriptable start = obj;
        while ((result = obj.get(cx, index, start)) == NOT_FOUND && (obj = obj.getPrototype(cx)) != null) {
        }
        return result;
    }

    public static boolean hasProperty(Scriptable obj, String name, Context cx) {
        return null != ScriptableObject.getBase(obj, name, cx);
    }

    public static void redefineProperty(Scriptable obj, String name, boolean isConst, Context cx) {
        ConstProperties cp;
        Scriptable base = ScriptableObject.getBase(obj, name, cx);
        if (base == null) {
            return;
        }
        if (base instanceof ConstProperties && (cp = (ConstProperties)((Object)base)).isConst(name)) {
            throw ScriptRuntime.typeError1(cx, "msg.const.redecl", name);
        }
        if (isConst) {
            throw ScriptRuntime.typeError1(cx, "msg.var.redecl", name);
        }
    }

    public static boolean hasProperty(Scriptable obj, int index, Context cx) {
        return null != ScriptableObject.getBase(cx, obj, index);
    }

    public static boolean hasProperty(Scriptable obj, Symbol key, Context cx) {
        return null != ScriptableObject.getBase(cx, obj, key);
    }

    public static void putProperty(Scriptable obj, String name, Object value, Context cx) {
        Scriptable base = ScriptableObject.getBase(obj, name, cx);
        if (base == null) {
            base = obj;
        }
        base.put(cx, name, obj, value);
    }

    public static void putProperty(Scriptable obj, Symbol key, Object value, Context cx) {
        Scriptable base = ScriptableObject.getBase(cx, obj, key);
        if (base == null) {
            base = obj;
        }
        ScriptableObject.ensureSymbolScriptable(base, cx).put(cx, key, obj, value);
    }

    public static void putConstProperty(Scriptable obj, String name, Object value, Context cx) {
        Scriptable base = ScriptableObject.getBase(obj, name, cx);
        if (base == null) {
            base = obj;
        }
        if (base instanceof ConstProperties) {
            ((ConstProperties)((Object)base)).putConst(cx, name, obj, value);
        }
    }

    public static void putProperty(Scriptable obj, int index, Object value, Context cx) {
        Scriptable base = ScriptableObject.getBase(cx, obj, index);
        if (base == null) {
            base = obj;
        }
        base.put(cx, index, obj, value);
    }

    public static boolean deleteProperty(Scriptable obj, String name, Context cx) {
        Scriptable base = ScriptableObject.getBase(obj, name, cx);
        if (base == null) {
            return true;
        }
        base.delete(cx, name);
        return !base.has(cx, name, obj);
    }

    public static boolean deleteProperty(Scriptable obj, int index, Context cx) {
        Scriptable base = ScriptableObject.getBase(cx, obj, index);
        if (base == null) {
            return true;
        }
        base.delete(cx, index);
        return !base.has(cx, index, obj);
    }

    public static Object[] getPropertyIds(Context cx, Scriptable obj) {
        if (obj == null) {
            return ScriptRuntime.EMPTY_OBJECTS;
        }
        Object[] result = obj.getIds(cx);
        ObjToIntMap map = null;
        while ((obj = obj.getPrototype(cx)) != null) {
            int i;
            Object[] ids = obj.getIds(cx);
            if (ids.length == 0) continue;
            if (map == null) {
                if (result.length == 0) {
                    result = ids;
                    continue;
                }
                map = new ObjToIntMap(result.length + ids.length);
                for (i = 0; i != result.length; ++i) {
                    map.intern(result[i]);
                }
                result = null;
            }
            for (i = 0; i != ids.length; ++i) {
                map.intern(ids[i]);
            }
        }
        if (map != null) {
            result = map.getKeys();
        }
        return result;
    }

    private static Scriptable getBase(Scriptable obj, String name, Context cx) {
        while (!obj.has(cx, name, obj) && (obj = obj.getPrototype(cx)) != null) {
        }
        return obj;
    }

    private static Scriptable getBase(Context cx, Scriptable obj, int index) {
        while (!obj.has(cx, index, obj) && (obj = obj.getPrototype(cx)) != null) {
        }
        return obj;
    }

    private static Scriptable getBase(Context cx, Scriptable obj, Symbol key) {
        while (!ScriptableObject.ensureSymbolScriptable(obj, cx).has(cx, key, obj) && (obj = obj.getPrototype(cx)) != null) {
        }
        return obj;
    }

    public static Object getTopScopeValue(Scriptable scope, Object key, Context cx) {
        scope = ScriptableObject.getTopLevelScope(scope);
        do {
            ScriptableObject so;
            Object value;
            if (!(scope instanceof ScriptableObject) || (value = (so = (ScriptableObject)scope).getAssociatedValue(key)) == null) continue;
            return value;
        } while ((scope = scope.getPrototype(cx)) != null);
        return null;
    }

    public ScriptableObject() {
        this.slotMap = ScriptableObject.createSlotMap(0);
    }

    public ScriptableObject(Scriptable scope, Scriptable prototype) {
        if (scope == null) {
            throw new IllegalArgumentException();
        }
        this.parentScopeObject = scope;
        this.prototypeObject = prototype;
        this.slotMap = ScriptableObject.createSlotMap(0);
    }

    @Override
    public MemberType getTypeOf() {
        return this.avoidObjectDetection() ? MemberType.UNDEFINED : MemberType.OBJECT;
    }

    @Override
    public abstract String getClassName();

    @Override
    public boolean has(Context cx, String name, Scriptable start) {
        return null != this.slotMap.query(name, 0);
    }

    @Override
    public boolean has(Context cx, int index, Scriptable start) {
        if (this.externalData != null) {
            return index < this.externalData.getArrayLength();
        }
        return null != this.slotMap.query(null, index);
    }

    @Override
    public boolean has(Context cx, Symbol key, Scriptable start) {
        return null != this.slotMap.query(key, 0);
    }

    @Override
    public Object get(Context cx, String name, Scriptable start) {
        Slot slot = this.slotMap.query(name, 0);
        if (slot == null) {
            return NOT_FOUND;
        }
        return slot.getValue(start, cx);
    }

    @Override
    public Object get(Context cx, int index, Scriptable start) {
        if (this.externalData != null) {
            if (index < this.externalData.getArrayLength()) {
                return this.externalData.getArrayElement(index);
            }
            return NOT_FOUND;
        }
        Slot slot = this.slotMap.query(null, index);
        if (slot == null) {
            return NOT_FOUND;
        }
        return slot.getValue(start, cx);
    }

    @Override
    public Object get(Context cx, Symbol key, Scriptable start) {
        Slot slot = this.slotMap.query(key, 0);
        if (slot == null) {
            return NOT_FOUND;
        }
        return slot.getValue(start, cx);
    }

    @Override
    public void put(Context cx, String name, Scriptable start, Object value) {
        if (this.putImpl(cx, name, 0, start, value)) {
            return;
        }
        if (start == this) {
            throw Kit.codeBug();
        }
        start.put(cx, name, start, value);
    }

    @Override
    public void put(Context cx, int index, Scriptable start, Object value) {
        if (this.externalData != null) {
            if (index >= this.externalData.getArrayLength()) {
                throw new JavaScriptException(cx, ScriptRuntime.newNativeError(cx, this, TopLevel.NativeErrors.RangeError, new Object[]{"External array index out of bounds "}), null, 0);
            }
            this.externalData.setArrayElement(index, value);
            return;
        }
        if (this.putImpl(cx, null, index, start, value)) {
            return;
        }
        if (start == this) {
            throw Kit.codeBug();
        }
        start.put(cx, index, start, value);
    }

    @Override
    public void put(Context cx, Symbol key, Scriptable start, Object value) {
        if (this.putImpl(cx, key, 0, start, value)) {
            return;
        }
        if (start == this) {
            throw Kit.codeBug();
        }
        ScriptableObject.ensureSymbolScriptable(start, cx).put(cx, key, start, value);
    }

    @Override
    public void delete(Context cx, String name) {
        this.checkNotSealed(cx, name, 0);
        Slot s = this.slotMap.query(name, 0);
        this.slotMap.remove(name, 0, cx);
        Deletable.deleteObject(s == null ? null : s.value);
    }

    @Override
    public void delete(Context cx, int index) {
        this.checkNotSealed(cx, null, index);
        Slot s = this.slotMap.query(null, index);
        this.slotMap.remove(null, index, cx);
        Deletable.deleteObject(s == null ? null : s.value);
    }

    @Override
    public void delete(Context cx, Symbol key) {
        this.checkNotSealed(cx, key, 0);
        this.slotMap.remove(key, 0, cx);
    }

    @Override
    public void putConst(Context cx, String name, Scriptable start, Object value) {
        if (this.putConstImpl(cx, name, 0, start, value, 1)) {
            return;
        }
        if (start == this) {
            throw Kit.codeBug();
        }
        if (start instanceof ConstProperties) {
            ((ConstProperties)((Object)start)).putConst(cx, name, start, value);
        } else {
            start.put(cx, name, start, value);
        }
    }

    @Override
    public void defineConst(Context cx, String name, Scriptable start) {
        if (this.putConstImpl(cx, name, 0, start, Undefined.INSTANCE, 8)) {
            return;
        }
        if (start == this) {
            throw Kit.codeBug();
        }
        if (start instanceof ConstProperties) {
            ((ConstProperties)((Object)start)).defineConst(cx, name, start);
        }
    }

    @Override
    public boolean isConst(String name) {
        Slot slot = this.slotMap.query(name, 0);
        if (slot == null) {
            return false;
        }
        return (slot.getAttributes() & 5) == 5;
    }

    public int getAttributes(Context cx, String name) {
        return this.findAttributeSlot(cx, name, 0, SlotAccess.QUERY).getAttributes();
    }

    public int getAttributes(Context cx, int index) {
        return this.findAttributeSlot(cx, null, index, SlotAccess.QUERY).getAttributes();
    }

    public int getAttributes(Context cx, Symbol sym) {
        return this.findAttributeSlot(cx, sym, SlotAccess.QUERY).getAttributes();
    }

    public void setAttributes(Context cx, String name, int attributes) {
        this.checkNotSealed(cx, name, 0);
        this.findAttributeSlot(cx, name, 0, SlotAccess.MODIFY).setAttributes(attributes);
    }

    public void setAttributes(Context cx, int index, int attributes) {
        this.checkNotSealed(cx, null, index);
        this.findAttributeSlot(cx, null, index, SlotAccess.MODIFY).setAttributes(attributes);
    }

    public void setAttributes(Context cx, Symbol key, int attributes) {
        this.checkNotSealed(cx, key, 0);
        this.findAttributeSlot(cx, key, SlotAccess.MODIFY).setAttributes(attributes);
    }

    public void setGetterOrSetter(Context cx, String name, int index, Callable getterOrSetter, boolean isSetter) {
        this.setGetterOrSetter(cx, name, index, getterOrSetter, isSetter, false);
    }

    private void setGetterOrSetter(Context cx, String name, int index, Callable getterOrSetter, boolean isSetter, boolean force) {
        int attributes;
        GetterSlot gslot;
        if (name != null && index != 0) {
            throw new IllegalArgumentException(name);
        }
        if (!force) {
            this.checkNotSealed(cx, name, index);
        }
        if (this.isExtensible()) {
            gslot = (GetterSlot)this.slotMap.get(name, index, SlotAccess.MODIFY_GETTER_SETTER);
        } else {
            Slot slot = this.slotMap.query(name, index);
            if (!(slot instanceof GetterSlot)) {
                return;
            }
            gslot = (GetterSlot)slot;
        }
        if (!force && ((attributes = gslot.getAttributes()) & 1) != 0) {
            throw Context.reportRuntimeError1("msg.modify.readonly", name, cx);
        }
        if (isSetter) {
            gslot.setter = getterOrSetter;
        } else {
            gslot.getter = getterOrSetter;
        }
        gslot.value = Undefined.INSTANCE;
    }

    public Object getGetterOrSetter(String name, int index, boolean isSetter) {
        if (name != null && index != 0) {
            throw new IllegalArgumentException(name);
        }
        Slot slot = this.slotMap.query(name, index);
        if (slot == null) {
            return null;
        }
        if (slot instanceof GetterSlot) {
            GetterSlot gslot = (GetterSlot)slot;
            Object result = isSetter ? gslot.setter : gslot.getter;
            return result != null ? result : Undefined.INSTANCE;
        }
        return Undefined.INSTANCE;
    }

    protected boolean isGetterOrSetter(String name, int index, boolean setter) {
        Slot slot = this.slotMap.query(name, index);
        if (slot instanceof GetterSlot) {
            if (setter && ((GetterSlot)slot).setter != null) {
                return true;
            }
            return !setter && ((GetterSlot)slot).getter != null;
        }
        return false;
    }

    public ExternalArrayData getExternalArrayData() {
        return this.externalData;
    }

    public void setExternalArrayData(Context cx, ExternalArrayData array) {
        this.externalData = array;
        if (array == null) {
            this.delete(cx, "length");
        } else {
            this.defineProperty(cx, "length", null, GET_ARRAY_LENGTH, null, 3);
        }
    }

    public Object getExternalArrayLength() {
        return this.externalData == null ? 0 : this.externalData.getArrayLength();
    }

    @Override
    public Scriptable getPrototype(Context cx) {
        return this.prototypeObject;
    }

    @Override
    public void setPrototype(Scriptable m) {
        this.prototypeObject = m;
    }

    @Override
    public Scriptable getParentScope() {
        return this.parentScopeObject;
    }

    @Override
    public void setParentScope(Scriptable m) {
        this.parentScopeObject = m;
    }

    @Override
    public Object[] getIds(Context cx) {
        return this.getIds(cx, false, false);
    }

    @Override
    public Object[] getAllIds(Context cx) {
        return this.getIds(cx, true, false);
    }

    @Override
    public Object getDefaultValue(Context cx, DefaultValueTypeHint typeHint) {
        return ScriptableObject.getDefaultValue(this, typeHint, cx);
    }

    @Override
    public boolean hasInstance(Context cx, Scriptable instance) {
        return ScriptRuntime.jsDelegatesTo(cx, instance, this);
    }

    public boolean avoidObjectDetection() {
        return false;
    }

    protected Object equivalentValues(Object value) {
        return this == value ? Boolean.TRUE : NOT_FOUND;
    }

    public void defineProperty(Context cx, String propertyName, Object value, int attributes) {
        this.checkNotSealed(cx, propertyName, 0);
        this.put(cx, propertyName, (Scriptable)this, value);
        this.setAttributes(cx, propertyName, attributes);
    }

    public void defineProperty(Context cx, Symbol key, Object value, int attributes) {
        this.checkNotSealed(cx, key, 0);
        this.put(cx, key, (Scriptable)this, value);
        this.setAttributes(cx, key, attributes);
    }

    public void defineProperty(Context cx, String propertyName, Class<?> clazz, int attributes) {
        int length = propertyName.length();
        if (length == 0) {
            throw new IllegalArgumentException();
        }
        char[] buf = new char[3 + length];
        propertyName.getChars(0, length, buf, 3);
        buf[3] = Character.toUpperCase(buf[3]);
        buf[0] = 103;
        buf[1] = 101;
        buf[2] = 116;
        String getterName = new String(buf);
        buf[0] = 115;
        String setterName = new String(buf);
        Method[] methods = FunctionObject.getMethodList(clazz);
        WrappedExecutable getter = WrappedReflectionMethod.of(FunctionObject.findSingleMethod(methods, getterName, cx));
        WrappedExecutable setter = WrappedReflectionMethod.of(FunctionObject.findSingleMethod(methods, setterName, cx));
        if (setter == null) {
            attributes |= 1;
        }
        this.defineProperty(cx, propertyName, null, getter, setter, attributes);
    }

    public void defineProperty(Context cx, String propertyName, Object delegateTo, WrappedExecutable getter, WrappedExecutable setter, int attributes) {
        MemberBox getterBox = null;
        if (getter != null) {
            getterBox = new MemberBox(getter);
            getterBox.delegateTo = !getter.isStatic() ? delegateTo : Void.TYPE;
        }
        MemberBox setterBox = null;
        if (setter != null) {
            if (setter.getReturnType() != Void.TYPE) {
                throw Context.reportRuntimeError1("msg.setter.return", setter.toString(), cx);
            }
            setterBox = new MemberBox(setter);
            setterBox.delegateTo = !setter.isStatic() ? delegateTo : Void.TYPE;
        }
        GetterSlot gslot = (GetterSlot)this.slotMap.get(propertyName, 0, SlotAccess.MODIFY_GETTER_SETTER);
        gslot.setAttributes(attributes);
        gslot.getter = getterBox;
        gslot.setter = setterBox;
    }

    public void defineOwnProperties(Context cx, ScriptableObject props) {
        int i;
        Object[] ids = props.getIds(cx, false, true);
        ScriptableObject[] descs = new ScriptableObject[ids.length];
        int len = ids.length;
        for (i = 0; i < len; ++i) {
            Object descObj = ScriptRuntime.getObjectElem(cx, props, ids[i]);
            ScriptableObject desc = ScriptableObject.ensureScriptableObject(descObj, cx);
            this.checkPropertyDefinition(cx, desc);
            descs[i] = desc;
        }
        len = ids.length;
        for (i = 0; i < len; ++i) {
            this.defineOwnProperty(cx, ids[i], descs[i]);
        }
    }

    public void defineOwnProperty(Context cx, Object id, ScriptableObject desc) {
        this.checkPropertyDefinition(cx, desc);
        this.defineOwnProperty(cx, id, desc, true);
    }

    protected void defineOwnProperty(Context cx, Object id, ScriptableObject desc, boolean checkValid) {
        int attributes;
        boolean isNew;
        Slot slot = this.getSlot(cx, id, SlotAccess.QUERY);
        boolean bl = isNew = slot == null;
        if (checkValid) {
            ScriptableObject current = slot == null ? null : slot.getPropertyDescriptor(cx, this);
            this.checkPropertyChange(cx, id, current, desc);
        }
        boolean isAccessor = this.isAccessorDescriptor(cx, desc);
        if (slot == null) {
            slot = this.getSlot(cx, id, isAccessor ? SlotAccess.MODIFY_GETTER_SETTER : SlotAccess.MODIFY);
            attributes = this.applyDescriptorToAttributeBitset(cx, 7, desc);
        } else {
            attributes = this.applyDescriptorToAttributeBitset(cx, slot.getAttributes(), desc);
        }
        if (isAccessor) {
            Object setter;
            if (!(slot instanceof GetterSlot)) {
                slot = this.getSlot(cx, id, SlotAccess.MODIFY_GETTER_SETTER);
            }
            GetterSlot gslot = (GetterSlot)slot;
            Object getter = ScriptableObject.getProperty((Scriptable)desc, "get", cx);
            if (getter != NOT_FOUND) {
                gslot.getter = getter;
            }
            if ((setter = ScriptableObject.getProperty((Scriptable)desc, "set", cx)) != NOT_FOUND) {
                gslot.setter = setter;
            }
            gslot.value = Undefined.INSTANCE;
            gslot.setAttributes(attributes);
        } else {
            Object value;
            if (slot instanceof GetterSlot && this.isDataDescriptor(desc, cx)) {
                slot = this.getSlot(cx, id, SlotAccess.CONVERT_ACCESSOR_TO_DATA);
            }
            if ((value = ScriptableObject.getProperty((Scriptable)desc, "value", cx)) != NOT_FOUND) {
                slot.value = value;
            } else if (isNew) {
                slot.value = Undefined.INSTANCE;
            }
            slot.setAttributes(attributes);
        }
    }

    protected void checkPropertyDefinition(Context cx, ScriptableObject desc) {
        Object getter = ScriptableObject.getProperty((Scriptable)desc, "get", cx);
        if (getter != NOT_FOUND && getter != Undefined.INSTANCE && !(getter instanceof Callable)) {
            throw ScriptRuntime.notFunctionError(cx, getter);
        }
        Object setter = ScriptableObject.getProperty((Scriptable)desc, "set", cx);
        if (setter != NOT_FOUND && setter != Undefined.INSTANCE && !(setter instanceof Callable)) {
            throw ScriptRuntime.notFunctionError(cx, setter);
        }
        if (this.isDataDescriptor(desc, cx) && this.isAccessorDescriptor(cx, desc)) {
            throw ScriptRuntime.typeError0(cx, "msg.both.data.and.accessor.desc");
        }
    }

    protected void checkPropertyChange(Context cx, Object id, ScriptableObject current, ScriptableObject desc) {
        if (current == null) {
            if (!this.isExtensible()) {
                throw ScriptRuntime.typeError0(cx, "msg.not.extensible");
            }
        } else if (ScriptableObject.isFalse(current.get(cx, "configurable", (Scriptable)current), cx)) {
            if (ScriptableObject.isTrue(ScriptableObject.getProperty((Scriptable)desc, "configurable", cx), cx)) {
                throw ScriptRuntime.typeError1(cx, "msg.change.configurable.false.to.true", id);
            }
            if (ScriptableObject.isTrue(current.get(cx, "enumerable", (Scriptable)current), cx) != ScriptableObject.isTrue(ScriptableObject.getProperty((Scriptable)desc, "enumerable", cx), cx)) {
                throw ScriptRuntime.typeError1(cx, "msg.change.enumerable.with.configurable.false", id);
            }
            boolean isData = this.isDataDescriptor(desc, cx);
            boolean isAccessor = this.isAccessorDescriptor(cx, desc);
            if (isData || isAccessor) {
                if (isData && this.isDataDescriptor(current, cx)) {
                    if (ScriptableObject.isFalse(current.get(cx, "writable", (Scriptable)current), cx)) {
                        if (ScriptableObject.isTrue(ScriptableObject.getProperty((Scriptable)desc, "writable", cx), cx)) {
                            throw ScriptRuntime.typeError1(cx, "msg.change.writable.false.to.true.with.configurable.false", id);
                        }
                        if (!this.sameValue(cx, ScriptableObject.getProperty((Scriptable)desc, "value", cx), current.get(cx, "value", (Scriptable)current))) {
                            throw ScriptRuntime.typeError1(cx, "msg.change.value.with.writable.false", id);
                        }
                    }
                } else if (isAccessor && this.isAccessorDescriptor(cx, current)) {
                    if (!this.sameValue(cx, ScriptableObject.getProperty((Scriptable)desc, "set", cx), current.get(cx, "set", (Scriptable)current))) {
                        throw ScriptRuntime.typeError1(cx, "msg.change.setter.with.configurable.false", id);
                    }
                    if (!this.sameValue(cx, ScriptableObject.getProperty((Scriptable)desc, "get", cx), current.get(cx, "get", (Scriptable)current))) {
                        throw ScriptRuntime.typeError1(cx, "msg.change.getter.with.configurable.false", id);
                    }
                } else {
                    if (this.isDataDescriptor(current, cx)) {
                        throw ScriptRuntime.typeError1(cx, "msg.change.property.data.to.accessor.with.configurable.false", id);
                    }
                    throw ScriptRuntime.typeError1(cx, "msg.change.property.accessor.to.data.with.configurable.false", id);
                }
            }
        }
    }

    protected boolean sameValue(Context cx, Object newValue, Object currentValue) {
        if (newValue == NOT_FOUND) {
            return true;
        }
        if (currentValue == NOT_FOUND) {
            currentValue = Undefined.INSTANCE;
        }
        if (currentValue instanceof Number && newValue instanceof Number) {
            double d1 = ((Number)currentValue).doubleValue();
            double d2 = ((Number)newValue).doubleValue();
            if (Double.isNaN(d1) && Double.isNaN(d2)) {
                return true;
            }
            if (d1 == 0.0 && Double.doubleToLongBits(d1) != Double.doubleToLongBits(d2)) {
                return false;
            }
        }
        return ScriptRuntime.shallowEq(cx, currentValue, newValue);
    }

    protected int applyDescriptorToAttributeBitset(Context cx, int attributes, ScriptableObject desc) {
        Object configurable;
        Object writable;
        Object enumerable = ScriptableObject.getProperty((Scriptable)desc, "enumerable", cx);
        if (enumerable != NOT_FOUND) {
            int n = attributes = ScriptRuntime.toBoolean(cx, enumerable) ? attributes & 0xFFFFFFFD : attributes | 2;
        }
        if ((writable = ScriptableObject.getProperty((Scriptable)desc, "writable", cx)) != NOT_FOUND) {
            int n = attributes = ScriptRuntime.toBoolean(cx, writable) ? attributes & 0xFFFFFFFE : attributes | 1;
        }
        if ((configurable = ScriptableObject.getProperty((Scriptable)desc, "configurable", cx)) != NOT_FOUND) {
            attributes = ScriptRuntime.toBoolean(cx, configurable) ? attributes & 0xFFFFFFFB : attributes | 4;
        }
        return attributes;
    }

    protected boolean isDataDescriptor(ScriptableObject desc, Context cx) {
        return ScriptableObject.hasProperty((Scriptable)desc, "value", cx) || ScriptableObject.hasProperty((Scriptable)desc, "writable", cx);
    }

    protected boolean isAccessorDescriptor(Context cx, ScriptableObject desc) {
        return ScriptableObject.hasProperty((Scriptable)desc, "get", cx) || ScriptableObject.hasProperty((Scriptable)desc, "set", cx);
    }

    protected boolean isGenericDescriptor(Context cx, ScriptableObject desc) {
        return !this.isDataDescriptor(desc, cx) && !this.isAccessorDescriptor(cx, desc);
    }

    public void defineFunctionProperties(Context cx, String[] names, Class<?> clazz, int attributes) {
        Method[] methods = FunctionObject.getMethodList(clazz);
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            Method m = FunctionObject.findSingleMethod(methods, name, cx);
            if (m == null) {
                throw Context.reportRuntimeError2("msg.method.not.found", name, clazz.getName(), cx);
            }
            FunctionObject f = new FunctionObject(name, m, this, cx);
            this.defineProperty(cx, name, (Object)f, attributes);
        }
    }

    public boolean isExtensible() {
        return this.isExtensible;
    }

    public void preventExtensions() {
        this.isExtensible = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sealObject(Context cx) {
        if (!this.isSealed) {
            long stamp = this.slotMap.readLock();
            try {
                this.isSealed = true;
            }
            finally {
                this.slotMap.unlockRead(stamp);
            }
        }
    }

    public final boolean isSealed(Context cx) {
        return this.isSealed;
    }

    private void checkNotSealed(Context cx, Object key, int index) {
        if (!this.isSealed(cx)) {
            return;
        }
        String str = key != null ? key.toString() : Integer.toString(index);
        throw Context.reportRuntimeError1("msg.modify.sealed", str, cx);
    }

    public final Object getAssociatedValue(Object key) {
        Map<Object, Object> h = this.associatedValues;
        if (h == null) {
            return null;
        }
        return h.get(key);
    }

    public final synchronized Object associateValue(Object key, Object value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        Map<Object, Object> h = this.associatedValues;
        if (h == null) {
            this.associatedValues = h = new HashMap<Object, Object>();
        }
        return Kit.initHash(h, key, value);
    }

    private boolean putImpl(Context cx, Object key, int index, Scriptable start, Object value) {
        Slot slot;
        if (this != start) {
            slot = this.slotMap.query(key, index);
            if (!this.isExtensible && (slot == null || !(slot instanceof GetterSlot) && (slot.getAttributes() & 1) != 0) && cx.isStrictMode()) {
                throw ScriptRuntime.typeError0(cx, "msg.not.extensible");
            }
            if (slot == null) {
                return false;
            }
        } else if (!this.isExtensible) {
            slot = this.slotMap.query(key, index);
            if ((slot == null || !(slot instanceof GetterSlot) && (slot.getAttributes() & 1) != 0) && cx.isStrictMode()) {
                throw ScriptRuntime.typeError0(cx, "msg.not.extensible");
            }
            if (slot == null) {
                return true;
            }
        } else {
            if (this.isSealed) {
                this.checkNotSealed(cx, key, index);
            }
            slot = this.slotMap.get(key, index, SlotAccess.MODIFY);
        }
        return slot.setValue(value, this, start, cx);
    }

    private boolean putConstImpl(Context cx, String name, int index, Scriptable start, Object value, int constFlag) {
        Slot slot;
        assert (constFlag != 0);
        if (!this.isExtensible && cx.isStrictMode()) {
            throw ScriptRuntime.typeError0(cx, "msg.not.extensible");
        }
        if (this != start) {
            slot = this.slotMap.query(name, index);
            if (slot == null) {
                return false;
            }
        } else if (!this.isExtensible()) {
            slot = this.slotMap.query(name, index);
            if (slot == null) {
                return true;
            }
        } else {
            this.checkNotSealed(cx, name, index);
            Slot slot2 = this.slotMap.get(name, index, SlotAccess.MODIFY_CONST);
            int attr = slot2.getAttributes();
            if ((attr & 1) == 0) {
                throw Context.reportRuntimeError1("msg.var.redecl", name, cx);
            }
            if ((attr & 8) != 0) {
                slot2.value = value;
                if (constFlag != 8) {
                    slot2.setAttributes(attr & 0xFFFFFFF7);
                }
            }
            return true;
        }
        return slot.setValue(value, this, start, cx);
    }

    private Slot findAttributeSlot(Context cx, String name, int index, SlotAccess accessType) {
        Slot slot = this.slotMap.get(name, index, accessType);
        if (slot == null) {
            String str = name != null ? name : Integer.toString(index);
            throw Context.reportRuntimeError1("msg.prop.not.found", str, cx);
        }
        return slot;
    }

    private Slot findAttributeSlot(Context cx, Symbol key, SlotAccess accessType) {
        Slot slot = this.slotMap.get(key, 0, accessType);
        if (slot == null) {
            throw Context.reportRuntimeError1("msg.prop.not.found", key, cx);
        }
        return slot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object[] getIds(Context cx, boolean getNonEnumerable, boolean getSymbols) {
        Object[] result;
        Object[] a;
        int externalLen;
        int n = externalLen = this.externalData == null ? 0 : this.externalData.getArrayLength();
        if (externalLen == 0) {
            a = ScriptRuntime.EMPTY_OBJECTS;
        } else {
            a = new Object[externalLen];
            for (int i = 0; i < externalLen; ++i) {
                a[i] = i;
            }
        }
        if (this.slotMap.isEmpty()) {
            return a;
        }
        int c = externalLen;
        long stamp = this.slotMap.readLock();
        try {
            for (Slot slot : this.slotMap) {
                if (!getNonEnumerable && (slot.getAttributes() & 2) != 0 || !getSymbols && slot.name instanceof Symbol) continue;
                if (c == externalLen) {
                    Object[] oldA = a;
                    a = new Object[this.slotMap.dirtySize() + externalLen];
                    if (oldA != null) {
                        System.arraycopy(oldA, 0, a, 0, externalLen);
                    }
                }
                a[c++] = slot.name != null ? slot.name : Integer.valueOf(slot.indexOrHash);
            }
        }
        finally {
            this.slotMap.unlockRead(stamp);
        }
        if (c == a.length + externalLen) {
            result = a;
        } else {
            result = new Object[c];
            System.arraycopy(a, 0, result, 0, c);
        }
        if (cx != null) {
            Arrays.sort(result, KEY_COMPARATOR);
        }
        return result;
    }

    protected ScriptableObject getOwnPropertyDescriptor(Context cx, Object id) {
        Slot slot = this.getSlot(cx, id, SlotAccess.QUERY);
        if (slot == null) {
            return null;
        }
        Scriptable scope = this.getParentScope();
        return slot.getPropertyDescriptor(cx, scope == null ? this : scope);
    }

    protected Slot getSlot(Context cx, Object id, SlotAccess accessType) {
        if (id instanceof Symbol) {
            return this.slotMap.get(id, 0, accessType);
        }
        ScriptRuntime.StringIdOrIndex s = ScriptRuntime.toStringIdOrIndex(cx, id);
        if (s.stringId == null) {
            return this.slotMap.get(null, s.index, accessType);
        }
        return this.slotMap.get(s.stringId, 0, accessType);
    }

    public int size() {
        return this.slotMap.size();
    }

    public boolean isEmpty() {
        return this.slotMap.isEmpty();
    }

    public Object get(Context cx, Object key) {
        Object value = null;
        if (key instanceof String) {
            value = this.get(cx, (String)key, (Scriptable)this);
        } else if (key instanceof Symbol) {
            value = this.get(cx, (Symbol)key, (Scriptable)this);
        } else if (key instanceof Number) {
            value = this.get(cx, ((Number)key).intValue(), (Scriptable)this);
        }
        if (value == NOT_FOUND || value == Undefined.INSTANCE) {
            return null;
        }
        if (value instanceof Wrapper) {
            return ((Wrapper)value).unwrap();
        }
        return value;
    }

    static class Slot {
        Object name;
        int indexOrHash;
        Object value;
        transient Slot next;
        transient Slot orderedNext;
        private short attributes;

        Slot(Object name, int indexOrHash, int attributes) {
            this.name = name;
            this.indexOrHash = indexOrHash;
            this.attributes = (short)attributes;
        }

        boolean setValue(Object value, Scriptable owner, Scriptable start, Context cx) {
            if ((this.attributes & 1) != 0) {
                if (cx.isStrictMode()) {
                    throw ScriptRuntime.typeError1(cx, "msg.modify.readonly", this.name);
                }
                return true;
            }
            if (owner == start) {
                this.value = value;
                return true;
            }
            return false;
        }

        Object getValue(Scriptable start, Context cx) {
            return this.value;
        }

        int getAttributes() {
            return this.attributes;
        }

        synchronized void setAttributes(int value) {
            ScriptableObject.checkValidAttributes(value);
            this.attributes = (short)value;
        }

        ScriptableObject getPropertyDescriptor(Context cx, Scriptable scope) {
            return ScriptableObject.buildDataDescriptor(scope, this.value, this.attributes, cx);
        }
    }

    static enum SlotAccess {
        QUERY,
        MODIFY,
        MODIFY_CONST,
        MODIFY_GETTER_SETTER,
        CONVERT_ACCESSOR_TO_DATA;

    }

    static final class GetterSlot
    extends Slot {
        Object getter;
        Object setter;

        GetterSlot(Object name, int indexOrHash, int attributes) {
            super(name, indexOrHash, attributes);
        }

        @Override
        ScriptableObject getPropertyDescriptor(Context cx, Scriptable scope) {
            String fName;
            int attr = this.getAttributes();
            NativeObject desc = new NativeObject(cx.factory);
            ScriptRuntime.setBuiltinProtoAndParent(cx, scope, desc, TopLevel.Builtins.Object);
            desc.defineProperty(cx, "enumerable", (Object)((attr & 2) == 0 ? 1 : 0), 0);
            desc.defineProperty(cx, "configurable", (Object)((attr & 4) == 0 ? 1 : 0), 0);
            if (this.getter == null && this.setter == null) {
                desc.defineProperty(cx, "writable", (Object)((attr & 1) == 0 ? 1 : 0), 0);
            }
            String string = fName = this.name == null ? "f" : this.name.toString();
            if (this.getter != null) {
                if (this.getter instanceof MemberBox) {
                    desc.defineProperty(cx, "get", (Object)new FunctionObject(fName, ((MemberBox)this.getter).member(), scope, cx), 0);
                } else if (this.getter instanceof Member) {
                    desc.defineProperty(cx, "get", (Object)new FunctionObject(fName, (Member)this.getter, scope, cx), 0);
                } else {
                    desc.defineProperty(cx, "get", this.getter, 0);
                }
            }
            if (this.setter != null) {
                if (this.setter instanceof MemberBox) {
                    desc.defineProperty(cx, "set", (Object)new FunctionObject(fName, ((MemberBox)this.setter).member(), scope, cx), 0);
                } else if (this.setter instanceof Member) {
                    desc.defineProperty(cx, "set", (Object)new FunctionObject(fName, (Member)this.setter, scope, cx), 0);
                } else {
                    desc.defineProperty(cx, "set", this.setter, 0);
                }
            }
            return desc;
        }

        @Override
        boolean setValue(Object value, Scriptable owner, Scriptable start, Context cx) {
            if (this.setter == null) {
                if (this.getter != null) {
                    if (cx.isStrictMode()) {
                        Object prop = "";
                        if (this.name != null) {
                            prop = "[" + start.getClassName() + "]." + String.valueOf(this.name);
                        }
                        throw ScriptRuntime.typeError2(cx, "msg.set.prop.no.setter", prop, ScriptRuntime.toString(cx, value));
                    }
                    return true;
                }
            } else {
                Object object = this.setter;
                if (object instanceof MemberBox) {
                    Object[] args;
                    Object setterThis;
                    MemberBox nativeSetter = (MemberBox)object;
                    Class[] pTypes = nativeSetter.argTypes;
                    Class valueType = pTypes[pTypes.length - 1];
                    int tag = FunctionObject.getTypeTag(valueType);
                    Object actualArg = FunctionObject.convertArg(cx, start, value, tag);
                    if (nativeSetter.delegateTo == null) {
                        setterThis = start;
                        args = new Object[]{actualArg};
                    } else {
                        setterThis = nativeSetter.delegateTo;
                        args = new Object[]{cx, start, actualArg};
                    }
                    nativeSetter.invoke(setterThis, args, cx, start);
                } else {
                    object = this.setter;
                    if (object instanceof Function) {
                        Function f = (Function)object;
                        f.call(cx, f.getParentScope(), start, new Object[]{value});
                    }
                }
                return true;
            }
            return super.setValue(value, owner, start, cx);
        }

        @Override
        Object getValue(Scriptable start, Context cx) {
            if (this.getter != null) {
                Object object = this.getter;
                if (object instanceof MemberBox) {
                    Object[] args;
                    Object getterThis;
                    MemberBox nativeGetter = (MemberBox)object;
                    if (nativeGetter.delegateTo == null) {
                        getterThis = start;
                        args = ScriptRuntime.EMPTY_OBJECTS;
                    } else {
                        getterThis = nativeGetter.delegateTo;
                        args = new Object[]{cx, start};
                    }
                    return nativeGetter.invoke(getterThis, args, cx, start);
                }
                object = this.getter;
                if (object instanceof Function) {
                    Function f = (Function)object;
                    return f.call(cx, f.getParentScope(), start, ScriptRuntime.EMPTY_OBJECTS);
                }
            }
            return this.value;
        }
    }

    public static final class KeyComparator
    implements Comparator<Object>,
    Serializable {
        private static final long serialVersionUID = 6411335891523988149L;

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 instanceof Integer) {
                if (o2 instanceof Integer) {
                    int i2;
                    int i1 = (Integer)o1;
                    if (i1 < (i2 = ((Integer)o2).intValue())) {
                        return -1;
                    }
                    if (i1 > i2) {
                        return 1;
                    }
                    return 0;
                }
                return -1;
            }
            if (o2 instanceof Integer) {
                return 1;
            }
            return 0;
        }
    }
}

